/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.dataway.config.CorsUtils;
import net.hasor.dataway.service.ApiCallService;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerFilter;

class InterfaceApiFilter
implements InvokerFilter {
    @Inject
    private ApiCallService apiCallService;
    private String apiBaseUri;

    public InterfaceApiFilter(String apiBaseUri) {
        this.apiBaseUri = apiBaseUri;
    }

    public void init(InvokerConfig config) {
        config.getAppContext().justInject((Object)this);
    }

    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String requestURI = httpRequest.getRequestURI();
        if (!requestURI.startsWith(this.apiBaseUri)) {
            return chain.doNext(invoker);
        }
        httpRequest.setCharacterEncoding("UTF-8");
        httpResponse.setCharacterEncoding("UTF-8");
        CorsUtils.setup(invoker);
        Map<String, Object> objectMap = this.apiCallService.doCall(invoker);
        if (!httpResponse.isCommitted()) {
            String body = JSON.toJSONString(objectMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            byte[] bodyByte = body.getBytes();
            httpResponse.setContentType(invoker.getMimeType("json"));
            httpResponse.setContentLength(bodyByte.length);
            ServletOutputStream output = httpResponse.getOutputStream();
            output.write(bodyByte);
            output.flush();
            output.close();
        }
        return objectMap;
    }
}

