/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.config;

import java.util.LinkedHashMap;
import java.util.Map;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.runtime.ThrowRuntimeException;
import net.hasor.dataway.config.Result;

public class DatawayUtils {
    private static final ThreadLocal<Long> localRequestTime = ThreadLocal.withInitial(System::currentTimeMillis);

    public static String evalCodeValueForSQL(String strCodeValue, Map<String, Object> strRequestBody) {
        StringBuilder paramKeyBuilder = new StringBuilder("");
        StringBuilder callKeyBuilder = new StringBuilder("");
        for (String key : strRequestBody.keySet()) {
            paramKeyBuilder.append("`" + key + "`,");
            callKeyBuilder.append("${" + key + "},");
        }
        if (paramKeyBuilder.length() > 0) {
            paramKeyBuilder.deleteCharAt(paramKeyBuilder.length() - 1);
            callKeyBuilder.deleteCharAt(callKeyBuilder.length() - 1);
        }
        strCodeValue = "var tempCall = @@sql(" + paramKeyBuilder.toString() + ")<%" + strCodeValue + "%>;\n";
        strCodeValue = strCodeValue + "return tempCall(" + callKeyBuilder.toString() + ");";
        return strCodeValue;
    }

    public static void resetLocalTime() {
        localRequestTime.remove();
        localRequestTime.set(System.currentTimeMillis());
    }

    public static long currentLostTime() {
        return System.currentTimeMillis() - localRequestTime.get();
    }

    public static Result<Map<String, Object>> queryResultToResult(final QueryResult queryResult) {
        return Result.of(new LinkedHashMap<String, Object>(){
            {
                this.put("success", true);
                this.put("message", "OK");
                this.put("code", queryResult.getCode());
                this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                this.put("executionTime", queryResult.executionTime());
                this.put("value", queryResult.getData().unwrap());
            }
        });
    }

    public static Result<Map<String, Object>> exceptionToResult(final Exception e) {
        if (e instanceof ThrowRuntimeException) {
            return Result.of(new LinkedHashMap<String, Object>(){
                {
                    this.put("success", false);
                    this.put("message", e.getMessage());
                    this.put("code", ((ThrowRuntimeException)e).getThrowCode());
                    this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                    this.put("executionTime", ((ThrowRuntimeException)e).getExecutionTime());
                    this.put("value", ((ThrowRuntimeException)e).getResult().unwrap());
                }
            });
        }
        return Result.of(new LinkedHashMap<String, Object>(){
            {
                this.put("success", false);
                this.put("message", e.getMessage());
                this.put("code", 500);
                this.put("lifeCycleTime", DatawayUtils.currentLostTime());
                this.put("executionTime", -1);
                this.put("value", e.getMessage());
            }
        });
    }
}

