/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.web.pdf.PdfCoreReport;
import net.bull.javamelody.internal.web.pdf.PdfDocumentFactory;
import net.bull.javamelody.internal.web.pdf.PdfFonts;

public class PdfReport {
    private final Document document;
    private final OutputStream output;
    private final PdfCoreReport pdfCoreReport;

    public PdfReport(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Range range, OutputStream output) throws IOException {
        assert (output != null);
        this.output = output;
        try {
            PdfDocumentFactory pdfDocumentFactory = new PdfDocumentFactory(collector.getApplication(), range, output);
            this.document = pdfDocumentFactory.createDocument();
            this.pdfCoreReport = new PdfCoreReport(collector, collectorServer, javaInformationsList, range, pdfDocumentFactory, this.document);
        }
        catch (DocumentException e) {
            throw PdfReport.createIOException(e);
        }
    }

    public PdfReport(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Period period, OutputStream output) throws IOException {
        this(collector, collectorServer, javaInformationsList, period.getRange(), output);
    }

    private static IOException createIOException(DocumentException e) {
        return new IOException(e.getMessage(), e);
    }

    public static String getFileName(String application) {
        return "JavaMelody_" + application.replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + ".pdf";
    }

    public static boolean shouldUseEnglishInsteadOfUkrainian() {
        return PdfFonts.shouldUseEnglishInsteadOfUkrainian();
    }

    public void toPdf() throws IOException {
        try {
            this.document.open();
            this.pdfCoreReport.toPdf();
        }
        catch (DocumentException e) {
            throw PdfReport.createIOException(e);
        }
        this.document.close();
    }

    public void preInitGraphs(Map<String, byte[]> newSmallGraphs, Map<String, byte[]> newSmallOtherGraphs, Map<String, byte[]> newLargeGraphs) {
        this.pdfCoreReport.preInitGraphs(newSmallGraphs, newSmallOtherGraphs, newLargeGraphs);
    }

    public void setCounterRange(Range counterRange) {
        this.pdfCoreReport.setCounterRange(counterRange);
    }

    public void setCurrentRequests(List<CounterRequestContext> currentRequests) {
        this.pdfCoreReport.setCurrentRequests(currentRequests);
    }

    public void close() throws IOException {
        this.output.close();
    }
}

