/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.List;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.web.pdf.PdfAbstractReport;
import net.bull.javamelody.internal.web.pdf.PdfFonts;

class PdfMBeansReport
extends PdfAbstractReport {
    private final List<MBeanNode> mbeans;
    private final Font boldFont = PdfFonts.BOLD.getFont();
    private final Font normalFont = PdfFonts.NORMAL.getFont();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private int margin;
    private PdfPTable currentTable;

    PdfMBeansReport(List<MBeanNode> mbeans, Document document) {
        super(document);
        assert (mbeans != null);
        this.mbeans = mbeans;
    }

    @Override
    void toPdf() throws DocumentException {
        this.writeTree();
    }

    void writeTree() throws DocumentException {
        this.margin = 0;
        MBeanNode platformNode = this.mbeans.get(0);
        this.writeTree(platformNode.getChildren());
        for (MBeanNode node : this.mbeans) {
            if (node == platformNode) continue;
            this.newPage();
            this.addToDocument((Element)new Chunk(node.getName(), this.boldFont));
            this.margin = 0;
            this.writeTree(node.getChildren());
        }
    }

    private void writeTree(List<MBeanNode> nodes) throws DocumentException {
        int marginBackup = this.margin;
        for (MBeanNode node : nodes) {
            this.margin = marginBackup;
            List<MBeanNode> children = node.getChildren();
            if (children != null) {
                this.addText(node.getName());
                this.margin += 12;
                this.writeTree(children);
                continue;
            }
            this.writeMBeanNode(node);
        }
    }

    private void writeMBeanNode(MBeanNode mbean) throws DocumentException {
        String mbeanName = mbean.getName();
        int indexOfComma = mbeanName.indexOf(44);
        if (indexOfComma != -1) {
            mbeanName = mbeanName.substring(indexOfComma + 1);
            this.addText(mbeanName);
            this.margin += 13;
        }
        this.writeAttributes(mbean);
    }

    private void writeAttributes(MBeanNode mbean) throws DocumentException {
        String description = mbean.getDescription();
        List<MBeanNode.MBeanAttribute> attributes = mbean.getAttributes();
        if (description != null || !attributes.isEmpty()) {
            this.currentTable = PdfMBeansReport.createAttributesTable();
            if (description != null) {
                this.currentTable.getDefaultCell().setColspan(3);
                this.addCell('(' + description + ')');
                this.currentTable.getDefaultCell().setColspan(1);
            }
            for (MBeanNode.MBeanAttribute attribute : attributes) {
                this.writeAttribute(attribute);
            }
            Paragraph paragraph = new Paragraph();
            paragraph.setIndentationLeft((float)this.margin);
            paragraph.add((Object)this.currentTable);
            this.addToDocument((Element)paragraph);
            this.addText("\n");
        }
    }

    private void writeAttribute(MBeanNode.MBeanAttribute attribute) {
        this.addCell(attribute.getName());
        this.addCell(attribute.getFormattedValue());
        String description = attribute.getDescription();
        if (description != null) {
            this.addCell('(' + description + ')');
        } else {
            this.addCell("");
        }
    }

    private static PdfPTable createAttributesTable() {
        PdfPTable table = new PdfPTable(3);
        table.setWidthPercentage(100.0f);
        PdfPCell defaultCell = table.getDefaultCell();
        defaultCell.setPaddingLeft(2.0f);
        defaultCell.setPaddingRight(2.0f);
        defaultCell.setVerticalAlignment(4);
        defaultCell.setBorder(0);
        return table;
    }

    private void addText(String text) throws DocumentException {
        Paragraph paragraph = new Paragraph(text, this.normalFont);
        paragraph.setIndentationLeft((float)this.margin);
        this.addToDocument((Element)paragraph);
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

