/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import javax.management.JMException;
import javax.management.ObjectName;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.MBeansAccessor;
import net.bull.javamelody.internal.model.PID;

public final class VirtualMachine {
    private static boolean enabled = VirtualMachine.isSupported();
    private static Object jvmVirtualMachine;

    private VirtualMachine() {
    }

    public static boolean isSupported() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVmName = System.getProperty("java.vm.name");
        return javaVendor.contains("Sun") || javaVendor.contains("Oracle") || javaVendor.contains("Apple") || VirtualMachine.isJRockit() || javaVmName.contains("OpenJDK");
    }

    public static boolean isJRockit() {
        return System.getProperty("java.vendor").contains("BEA");
    }

    public static synchronized boolean isEnabled() {
        return enabled;
    }

    public static synchronized Object getJvmVirtualMachine() throws Exception {
        if (jvmVirtualMachine == null) {
            Class<?> virtualMachineClass = VirtualMachine.findVirtualMachineClass();
            Method attachMethod = virtualMachineClass.getMethod("attach", String.class);
            String pid = PID.getPID();
            try {
                jvmVirtualMachine = VirtualMachine.invoke(attachMethod, null, pid);
                enabled = jvmVirtualMachine != null;
            }
            catch (Throwable throwable) {
                enabled = jvmVirtualMachine != null;
                throw throwable;
            }
        }
        return jvmVirtualMachine;
    }

    private static Class<?> findVirtualMachineClass() throws Exception {
        String virtualMachineClassName = "com.sun.tools.attach.VirtualMachine";
        try {
            return Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException e) {
            String[] defaultToolsLocation;
            File file = new File(System.getProperty("java.home"));
            if ("jre".equalsIgnoreCase(file.getName())) {
                file = file.getParentFile();
            }
            for (String name : defaultToolsLocation = new String[]{"lib", "tools.jar"}) {
                file = new File(file, name);
            }
            if (!file.exists()) {
                throw e;
            }
            URL url = file.toURI().toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader cl = URLClassLoader.newInstance(urls);
            return Class.forName("com.sun.tools.attach.VirtualMachine", true, cl);
        }
    }

    public static synchronized void detach() throws Exception {
        if (jvmVirtualMachine != null) {
            Class<?> virtualMachineClass = jvmVirtualMachine.getClass();
            Method detachMethod = virtualMachineClass.getMethod("detach", new Class[0]);
            jvmVirtualMachine = VirtualMachine.invoke(detachMethod, jvmVirtualMachine, new Object[0]);
            jvmVirtualMachine = null;
        }
    }

    public static InputStream heapHisto() throws Exception {
        if (!VirtualMachine.isSupported()) {
            throw new IllegalStateException(I18N.getString("heap_histo_non_supporte"));
        }
        if (!VirtualMachine.isEnabled()) {
            throw new IllegalStateException(I18N.getString("heap_histo_non_actif"));
        }
        try {
            ObjectName objectName = new ObjectName("com.sun.management:type=DiagnosticCommand");
            String gcClassHistogram = (String)MBeansAccessor.invoke(objectName, "gcClassHistogram", new Object[]{null}, new Class[]{String[].class});
            return new ByteArrayInputStream(gcClassHistogram.getBytes(StandardCharsets.UTF_8));
        }
        catch (JMException e1) {
            try {
                Class<?> virtualMachineClass = VirtualMachine.getJvmVirtualMachine().getClass();
                Method heapHistoMethod = virtualMachineClass.getMethod("heapHisto", Object[].class);
                return (InputStream)VirtualMachine.invoke(heapHistoMethod, VirtualMachine.getJvmVirtualMachine(), new Object[]{new Object[]{"-all"}});
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(I18N.getString("heap_histo_jre"), e);
            }
            catch (Exception e) {
                if ("Can not attach to current VM".equals(e.getMessage())) {
                    throw new IllegalStateException(I18N.getString("allowAttachSelf"), e);
                }
                if ("com.sun.tools.attach.AttachNotSupportedException".equals(e.getClass().getName())) {
                    throw new IllegalStateException(I18N.getString("heap_histo_jre"), e);
                }
                throw e;
            }
        }
    }

    public static HeapHistogram createHeapHistogram() throws Exception {
        try (InputStream input = VirtualMachine.heapHisto();){
            HeapHistogram heapHistogram = new HeapHistogram(input, VirtualMachine.isJRockit());
            return heapHistogram;
        }
    }

    private static Object invoke(Method method, Object object, Object ... args) throws Exception {
        try {
            return method.invoke(object, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new Exception(e.getCause());
        }
    }
}

