/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.internal.model.JavaInformations;

public final class HsErrPid
implements Serializable {
    private static final String XX_ERROR_FILE = "-XX:ErrorFile=";
    private static final long serialVersionUID = 1L;
    private static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("hs_err_pid") && name.endsWith(".log");
        }
    };
    private final String file;
    private final Date date;

    private HsErrPid(String file, Date date) {
        this.file = file;
        this.date = date;
    }

    public static List<HsErrPid> buildHsErrPidList() {
        ArrayList<File> directories = new ArrayList<File>();
        directories.add(new File("./"));
        directories.add(new File("/tmp"));
        String tmp = System.getenv("TMP");
        if (tmp != null) {
            directories.add(new File(tmp));
        }
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : args) {
            String errorFile;
            File dir;
            if (!arg.startsWith(XX_ERROR_FILE) || (dir = new File(errorFile = arg.substring(XX_ERROR_FILE.length())).getParentFile()) == null) continue;
            directories.add(dir);
        }
        ArrayList<HsErrPid> result = new ArrayList<HsErrPid>();
        for (File dir : directories) {
            File[] files = dir.listFiles(FILENAME_FILTER);
            if (files == null) continue;
            for (File file : files) {
                result.add(new HsErrPid(file.getAbsolutePath(), new Date(file.lastModified())));
            }
        }
        return result;
    }

    public static List<HsErrPid> getHsErrPidList(List<JavaInformations> javaInformationsList) {
        ArrayList<HsErrPid> result = new ArrayList<HsErrPid>();
        for (JavaInformations javaInformations : javaInformationsList) {
            List<HsErrPid> hsErrPidList = javaInformations.getHsErrPidList();
            if (hsErrPidList == null) continue;
            result.addAll(hsErrPidList);
        }
        Collections.sort(result, new HsErrPidComparator());
        return result;
    }

    public String getFile() {
        return this.file;
    }

    public Date getDate() {
        return this.date;
    }

    static final class HsErrPidComparator
    implements Comparator<HsErrPid>,
    Serializable {
        private static final long serialVersionUID = 1L;

        HsErrPidComparator() {
        }

        @Override
        public int compare(HsErrPid hsErrPid1, HsErrPid hsErrPid2) {
            return hsErrPid2.getDate().compareTo(hsErrPid1.getDate());
        }
    }
}

