/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.CounterError;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.CounterStorage;
import net.bull.javamelody.internal.model.ThreadInformations;

public class Counter
implements Cloneable,
Serializable {
    public static final String HTTP_COUNTER_NAME = "http";
    public static final String ERROR_COUNTER_NAME = "error";
    public static final String LOG_COUNTER_NAME = "log";
    public static final String JSP_COUNTER_NAME = "jsp";
    public static final String STRUTS_COUNTER_NAME = "struts";
    public static final String JSF_COUNTER_NAME = "jsf";
    public static final String SQL_COUNTER_NAME = "sql";
    public static final String JOB_COUNTER_NAME = "job";
    public static final String BUILDS_COUNTER_NAME = "builds";
    public static final int MAX_ERRORS_COUNT = 100;
    static final char TRANSFORM_REPLACEMENT_CHAR = '$';
    static final int MAX_REQUESTS_COUNT = 10000;
    private static final String TRANSFORM_REPLACEMENT = "\\$";
    private static final long serialVersionUID = 6759729262180992976L;
    private String application;
    private boolean displayed = true;
    private transient boolean used;
    private final String name;
    private final boolean errorCounter;
    private final String storageName;
    private final String iconName;
    private final String childCounterName;
    private final ConcurrentMap<String, CounterRequest> requests = new ConcurrentHashMap<String, CounterRequest>();
    private final ConcurrentMap<Long, CounterRequestContext> rootCurrentContextsByThreadId = new ConcurrentHashMap<Long, CounterRequestContext>();
    private final LinkedList<CounterError> errors;
    private Date startDate = new Date();
    private int maxRequestsCount = 10000;
    private long estimatedMemorySize;
    private final transient ThreadLocal<CounterRequestContext> contextThreadLocal;
    private transient Pattern requestTransformPattern;

    public Counter(String name, String iconName) {
        this(name, name, iconName, null, new ThreadLocal<CounterRequestContext>());
    }

    public Counter(String name, String storageName, String iconName, String childCounterName) {
        this(name, storageName, iconName, childCounterName, new ThreadLocal<CounterRequestContext>());
    }

    public Counter(String name, String iconName, Counter childCounter) {
        this(name, name, iconName, childCounter.getName(), childCounter.contextThreadLocal);
    }

    private Counter(String name, String storageName, String iconName, String childCounterName, ThreadLocal<CounterRequestContext> contextThreadLocal) {
        assert (name != null);
        assert (storageName != null);
        this.name = name;
        this.storageName = storageName;
        this.errorCounter = ERROR_COUNTER_NAME.equals(name) || LOG_COUNTER_NAME.equals(name) || JOB_COUNTER_NAME.equals(name);
        this.iconName = iconName;
        this.childCounterName = childCounterName;
        this.contextThreadLocal = contextThreadLocal;
        this.errors = this.errorCounter ? new LinkedList() : null;
    }

    void setApplication(String application) {
        assert (application != null);
        this.application = application;
    }

    String getApplication() {
        return this.application;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getChildCounterName() {
        return this.childCounterName;
    }

    boolean hasChildHits() {
        for (CounterRequest request : this.requests.values()) {
            if (!request.hasChildHits()) continue;
            return true;
        }
        return false;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    void setStartDate(Date startDate) {
        assert (startDate != null);
        this.startDate = startDate;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    Pattern getRequestTransformPattern() {
        return this.requestTransformPattern;
    }

    public void setRequestTransformPattern(Pattern requestTransformPattern) {
        this.requestTransformPattern = requestTransformPattern;
    }

    int getMaxRequestsCount() {
        return this.maxRequestsCount;
    }

    public void setMaxRequestsCount(int maxRequestsCount) {
        assert (maxRequestsCount > 0);
        this.maxRequestsCount = maxRequestsCount;
    }

    long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public void bindContextIncludingCpu(String requestName) {
        this.bindContext(requestName, requestName, null, ThreadInformations.getCurrentThreadCpuTime(), ThreadInformations.getCurrentThreadAllocatedBytes());
    }

    public void bindContext(String requestName, String completeRequestName, HttpServletRequest httpRequest, long startCpuTime, long startAllocatedBytes) {
        String remoteUser = null;
        String sessionId = null;
        if (httpRequest != null) {
            remoteUser = httpRequest.getRemoteUser();
            HttpSession session = httpRequest.getSession(false);
            if (session != null) {
                Object userAttribute;
                sessionId = session.getId();
                if (remoteUser == null && (userAttribute = session.getAttribute("javamelody.remoteUser")) instanceof String) {
                    remoteUser = (String)userAttribute;
                }
            }
        }
        CounterRequestContext context = new CounterRequestContext(this, this.contextThreadLocal.get(), requestName, completeRequestName, httpRequest, remoteUser, startCpuTime, startAllocatedBytes, sessionId);
        this.contextThreadLocal.set(context);
        if (context.getParentContext() == null) {
            this.rootCurrentContextsByThreadId.put(context.getThreadId(), context);
        }
    }

    public void unbindContext() {
        try {
            this.contextThreadLocal.remove();
        }
        finally {
            this.rootCurrentContextsByThreadId.remove(Thread.currentThread().getId());
        }
    }

    public void addRequestForCurrentContext(boolean systemError) {
        CounterRequestContext context = this.contextThreadLocal.get();
        if (context != null) {
            long duration = context.getDuration(System.currentTimeMillis());
            int cpuUsedMillis = context.getCpuTime();
            int allocatedKBytes = context.getAllocatedKBytes();
            this.addRequest(context.getRequestName(), duration, cpuUsedMillis, allocatedKBytes, systemError, -1L);
        }
    }

    public void addRequestForCurrentContext(String systemErrorStackTrace) {
        assert (this.errorCounter);
        CounterRequestContext context = this.contextThreadLocal.get();
        if (context != null) {
            long duration = context.getDuration(System.currentTimeMillis());
            int cpuUsedMillis = context.getCpuTime();
            int allocatedKBytes = context.getAllocatedKBytes();
            this.addRequest(context.getRequestName(), duration, cpuUsedMillis, allocatedKBytes, systemErrorStackTrace != null, systemErrorStackTrace, -1L);
        }
    }

    public void addRequest(String requestName, long duration, int cpuTime, int allocatedKBytes, boolean systemError, long responseSize) {
        this.addRequest(requestName, duration, cpuTime, allocatedKBytes, systemError, null, responseSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(String requestName, long duration, int cpuTime, int allocatedKBytes, boolean systemError, String systemErrorStackTrace, long responseSize) {
        CounterRequest request;
        assert (requestName != null);
        assert (duration >= 0L);
        assert (cpuTime >= -1);
        assert (allocatedKBytes >= -1);
        assert (responseSize >= -1L);
        String aggregateRequestName = this.getAggregateRequestName(requestName);
        CounterRequestContext context = this.contextThreadLocal.get();
        Cloneable cloneable = request = this.getCounterRequestInternal(aggregateRequestName);
        synchronized (cloneable) {
            request.addHit(duration, cpuTime, allocatedKBytes, systemError, systemErrorStackTrace, responseSize);
            if (context != null) {
                if (context.getParentCounter() == this) {
                    request.addChildHits(context);
                }
                request.addChildRequests(context.getChildRequestsExecutionsByRequestId());
            }
        }
        if (context != null) {
            if (context.getParentCounter() == this) {
                CounterRequestContext parentContext = context.getParentContext();
                if (parentContext == null) {
                    this.unbindContext();
                } else {
                    context.addChildRequest(this, aggregateRequestName, request.getId(), duration, systemError, responseSize);
                    parentContext.closeChildContext();
                    this.contextThreadLocal.set(parentContext);
                }
            } else {
                context.addChildRequest(this, aggregateRequestName, request.getId(), duration, systemError, responseSize);
            }
        }
        if (systemErrorStackTrace != null) {
            assert (this.errorCounter);
            cloneable = this.errors;
            synchronized (cloneable) {
                this.errors.addLast(new CounterError(requestName, systemErrorStackTrace));
                if (this.errors.size() > 100) {
                    this.errors.removeFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestForSystemError(String requestName, long duration, int cpuTime, int allocatedKBytes, String stackTrace) {
        CounterRequest request;
        assert (requestName != null);
        assert (duration >= -1L);
        assert (cpuTime >= -1);
        assert (this.errorCounter);
        assert (this.contextThreadLocal.get() == null);
        String aggregateRequestName = this.getAggregateRequestName(requestName);
        Cloneable cloneable = request = this.getCounterRequestInternal(aggregateRequestName);
        synchronized (cloneable) {
            request.addHit(duration, cpuTime, allocatedKBytes, true, stackTrace, -1L);
        }
        cloneable = this.errors;
        synchronized (cloneable) {
            this.errors.addLast(new CounterError(requestName, stackTrace));
            if (this.errors.size() > 100) {
                this.errors.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRumHit(String requestName, long networkTime, long domProcessing, long pageRendering) {
        assert (HTTP_COUNTER_NAME.equals(this.name));
        String aggregateRequestName = this.getAggregateRequestName(requestName);
        CounterRequest request = (CounterRequest)this.requests.get(aggregateRequestName);
        if (request != null) {
            CounterRequest counterRequest = request;
            synchronized (counterRequest) {
                request.addRumHit(networkTime, domProcessing, pageRendering);
            }
        }
    }

    public boolean isErrorCounter() {
        return this.errorCounter;
    }

    public boolean isJobCounter() {
        return JOB_COUNTER_NAME.equals(this.name);
    }

    public boolean isJspOrStrutsCounter() {
        return JSP_COUNTER_NAME.equals(this.name) || STRUTS_COUNTER_NAME.equals(this.name);
    }

    public boolean isBusinessFacadeCounter() {
        return "services".equals(this.name) || "ejb".equals(this.name) || "spring".equals(this.name) || "guice".equals(this.name);
    }

    public boolean isRequestIdFromThisCounter(String requestId) {
        return requestId.startsWith(this.getName());
    }

    private String getAggregateRequestName(String requestName) {
        String aggregateRequestName;
        if (this.requestTransformPattern == null) {
            aggregateRequestName = requestName;
        } else {
            Matcher matcher = this.requestTransformPattern.matcher(requestName);
            try {
                aggregateRequestName = matcher.replaceAll(TRANSFORM_REPLACEMENT);
            }
            catch (StackOverflowError e) {
                LOG.warn(e.toString(), e);
                return requestName;
            }
        }
        return aggregateRequestName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequestsAndErrors(Counter newCounter) {
        int maxRequests;
        assert (this.getName().equals(newCounter.getName()));
        for (CounterRequest newRequest : newCounter.getRequests()) {
            CounterRequest request;
            if (newRequest.getHits() <= 0L) continue;
            CounterRequest counterRequest = request = this.getCounterRequestInternal(newRequest.getName());
            synchronized (counterRequest) {
                request.addHits(newRequest);
            }
        }
        int size = this.requests.size();
        if (size > (maxRequests = this.getMaxRequestsCount())) {
            for (CounterRequest request : this.requests.values()) {
                if (request.getHits() >= 10L) continue;
                this.removeRequest(request.getName());
                if (--size > maxRequests) continue;
                break;
            }
        }
        if (this.isErrorCounter()) {
            this.addErrors(newCounter.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHits(CounterRequest counterRequest) {
        if (counterRequest.getHits() > 0L) {
            CounterRequest request;
            CounterRequest newRequest = counterRequest.clone();
            CounterRequest counterRequest2 = request = this.getCounterRequestInternal(newRequest.getName());
            synchronized (counterRequest2) {
                request.addHits(newRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrors(List<CounterError> counterErrorList) {
        assert (this.errorCounter);
        if (counterErrorList.isEmpty()) {
            return;
        }
        LinkedList<CounterError> linkedList = this.errors;
        synchronized (linkedList) {
            if (!this.errors.isEmpty() && this.errors.get(0).getTime() > counterErrorList.get(0).getTime()) {
                this.errors.addAll(0, counterErrorList);
            } else {
                this.errors.addAll(counterErrorList);
            }
            if (this.errors.size() > 1) {
                Collections.sort(this.errors, new CounterErrorComparator());
                while (this.errors.size() > 100) {
                    this.errors.removeFirst();
                }
            }
        }
    }

    void removeRequest(String requestName) {
        assert (requestName != null);
        this.requests.remove(requestName);
    }

    public CounterRequest getCounterRequest(CounterRequestContext context) {
        return this.getCounterRequestByName(context.getRequestName(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterRequest getCounterRequestByName(String requestName, boolean saveRequestIfAbsent) {
        CounterRequest request;
        String aggregateRequestName = this.getAggregateRequestName(requestName);
        CounterRequest counterRequest = request = this.getCounterRequestInternal(aggregateRequestName, saveRequestIfAbsent);
        synchronized (counterRequest) {
            return request.clone();
        }
    }

    private CounterRequest getCounterRequestInternal(String requestName) {
        return this.getCounterRequestInternal(requestName, true);
    }

    private CounterRequest getCounterRequestInternal(String requestName, boolean saveRequestIfAbsent) {
        CounterRequest request = (CounterRequest)this.requests.get(requestName);
        if (request == null) {
            CounterRequest precedentRequest;
            request = new CounterRequest(requestName, this.getName());
            if (saveRequestIfAbsent && (precedentRequest = this.requests.putIfAbsent(requestName, request)) != null) {
                request = precedentRequest;
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterRequest getCounterRequestById(String requestId) {
        if (this.isRequestIdFromThisCounter(requestId)) {
            for (CounterRequest request : this.requests.values()) {
                if (!request.getId().equals(requestId)) continue;
                CounterRequest counterRequest = request;
                synchronized (counterRequest) {
                    return request.clone();
                }
            }
        }
        return null;
    }

    public int getRequestsCount() {
        return this.requests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CounterRequest> getRequests() {
        ArrayList<CounterRequest> result = new ArrayList<CounterRequest>(this.requests.size());
        Iterator iterator = this.requests.values().iterator();
        while (iterator.hasNext()) {
            CounterRequest request;
            CounterRequest counterRequest = request = (CounterRequest)iterator.next();
            synchronized (counterRequest) {
                result.add(request.clone());
            }
        }
        return result;
    }

    public List<CounterRequest> getOrderedRequests() {
        List<CounterRequest> requestList = this.getRequests();
        if (requestList.size() > 1) {
            Collections.sort(requestList, Collections.reverseOrder(new CounterRequestComparator()));
        }
        return requestList;
    }

    List<CounterRequest> getOrderedByHitsRequests() {
        List<CounterRequest> requestList = this.getRequests();
        if (requestList.size() > 1) {
            Collections.sort(requestList, Collections.reverseOrder(new CounterRequestByHitsComparator()));
        }
        return requestList;
    }

    List<CounterRequestContext> getOrderedRootCurrentContexts() {
        ArrayList<CounterRequestContext> contextList = new ArrayList<CounterRequestContext>(this.rootCurrentContextsByThreadId.size());
        for (CounterRequestContext rootCurrentContext : this.rootCurrentContextsByThreadId.values()) {
            contextList.add(rootCurrentContext.clone());
        }
        if (contextList.size() > 1) {
            Collections.sort(contextList, Collections.reverseOrder(new CounterRequestContextComparator(System.currentTimeMillis())));
        }
        return contextList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CounterError> getErrors() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        LinkedList<CounterError> linkedList = this.errors;
        synchronized (linkedList) {
            return new ArrayList<CounterError>(this.errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorsCount() {
        if (this.errors == null) {
            return 0;
        }
        LinkedList<CounterError> linkedList = this.errors;
        synchronized (linkedList) {
            return this.errors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.requests.clear();
        if (this.errors != null) {
            LinkedList<CounterError> linkedList = this.errors;
            synchronized (linkedList) {
                this.errors.clear();
            }
        }
        this.startDate = new Date();
    }

    public Counter clone() {
        Counter clone = new Counter(this.getName(), this.getStorageName(), this.getIconName(), this.getChildCounterName(), new ThreadLocal<CounterRequestContext>());
        clone.application = this.getApplication();
        clone.startDate = this.getStartDate();
        clone.maxRequestsCount = this.getMaxRequestsCount();
        clone.displayed = this.isDisplayed();
        clone.requestTransformPattern = this.getRequestTransformPattern();
        for (CounterRequest request : this.getRequests()) {
            clone.requests.put(request.getName(), request);
        }
        if (this.errors != null) {
            clone.errors.addAll(this.getErrors());
        }
        return clone;
    }

    void writeToFile() throws IOException {
        Counter counter = this.clone();
        counter.rootCurrentContextsByThreadId.clear();
        this.estimatedMemorySize = new CounterStorage(counter).writeToFile();
    }

    void readFromFile() throws IOException {
        Counter counter = new CounterStorage(this).readFromFile();
        if (counter != null) {
            Counter newCounter = this.clone();
            this.startDate = counter.getStartDate();
            this.requests.clear();
            for (CounterRequest request : counter.getRequests()) {
                this.requests.put(request.getName(), request);
            }
            if (this.errors != null) {
                this.errors.clear();
                this.errors.addAll(counter.getErrors());
            }
            this.addRequestsAndErrors(newCounter);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[application=" + this.getApplication() + ", name=" + this.getName() + ", storageName=" + this.getStorageName() + ", startDate=" + this.getStartDate() + ", childCounterName=" + this.getChildCounterName() + ", " + this.requests.size() + " requests, " + (this.errors == null ? "" : this.errors.size() + " errors, ") + "maxRequestsCount=" + this.getMaxRequestsCount() + ", displayed=" + this.isDisplayed() + ']';
    }

    public static final class CounterRequestContextComparator
    implements Comparator<CounterRequestContext>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long timeOfSnapshot;

        public CounterRequestContextComparator(long timeOfSnapshot) {
            this.timeOfSnapshot = timeOfSnapshot;
        }

        @Override
        public int compare(CounterRequestContext context1, CounterRequestContext context2) {
            return Integer.compare(context1.getDuration(this.timeOfSnapshot), context2.getDuration(this.timeOfSnapshot));
        }
    }

    static final class CounterErrorComparator
    implements Comparator<CounterError>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CounterErrorComparator() {
        }

        @Override
        public int compare(CounterError error1, CounterError error2) {
            if (error1.getTime() < error2.getTime()) {
                return -1;
            }
            if (error1.getTime() > error2.getTime()) {
                return 1;
            }
            return 0;
        }
    }

    static final class CounterRequestByHitsComparator
    implements Comparator<CounterRequest>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CounterRequestByHitsComparator() {
        }

        @Override
        public int compare(CounterRequest request1, CounterRequest request2) {
            return Long.compare(request1.getHits(), request2.getHits());
        }
    }

    static final class CounterRequestComparator
    implements Comparator<CounterRequest>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CounterRequestComparator() {
        }

        @Override
        public int compare(CounterRequest request1, CounterRequest request2) {
            return Long.compare(request1.getDurationsSum(), request2.getDurationsSum());
        }
    }
}

