/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.SessionInformations;

public class SessionListener
implements HttpSessionListener,
HttpSessionActivationListener,
ServletContextListener,
Serializable {
    public static final String CSRF_TOKEN_SESSION_NAME = "javamelody." + HttpParameter.TOKEN.getName();
    public static final String SESSION_COUNTRY_KEY = "javamelody.country";
    public static final String SESSION_REMOTE_ADDR = "javamelody.remoteAddr";
    public static final String SESSION_REMOTE_USER = "javamelody.remoteUser";
    public static final String SESSION_USER_AGENT = "javamelody.userAgent";
    private static final String SESSION_ACTIVATION_KEY = "javamelody.sessionActivation";
    private static final long serialVersionUID = -1624944319058843901L;
    private static final AtomicInteger SESSION_COUNT = new AtomicInteger();
    private static final List<String> CONTEXT_PATHS = new ArrayList<String>();
    private static final ConcurrentMap<String, HttpSession> SESSION_MAP_BY_ID = new ConcurrentHashMap<String, HttpSession>();
    private static final ThreadLocal<HttpSession> SESSION_CONTEXT = new ThreadLocal();
    private static boolean instanceCreated;
    private boolean instanceEnabled;

    public SessionListener() {
        if (instanceCreated) {
            this.instanceEnabled = false;
        } else {
            this.instanceEnabled = true;
            SessionListener.setInstanceCreated(true);
        }
    }

    public SessionListener(boolean instanceEnabled) {
        this.instanceEnabled = instanceEnabled;
        SessionListener.setInstanceCreated(true);
    }

    private static void setInstanceCreated(boolean newInstanceCreated) {
        instanceCreated = newInstanceCreated;
    }

    public static int getSessionCount() {
        if (!instanceCreated) {
            return -1;
        }
        return SESSION_COUNT.get();
    }

    public static long getSessionAgeSum() {
        if (!instanceCreated) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        long result = 0L;
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            try {
                result += now - session.getCreationTime();
            }
            catch (Exception e) {}
        }
        return result;
    }

    static void invalidateAllSessions() {
        SessionListener.invalidateAllSessionsExceptCurrentSession(null);
    }

    public static void invalidateAllSessionsExceptCurrentSession(HttpSession currentSession) {
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            try {
                if (currentSession != null && currentSession.getId().equals(session.getId())) continue;
                session.invalidate();
            }
            catch (Exception e) {}
        }
    }

    public static void invalidateSession(String sessionId) {
        HttpSession session = SessionListener.getSessionById(sessionId);
        if (session != null) {
            try {
                session.invalidate();
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private static HttpSession getSessionById(String sessionId) {
        HttpSession session = (HttpSession)SESSION_MAP_BY_ID.get(sessionId);
        if (session == null) {
            for (HttpSession other : SESSION_MAP_BY_ID.values()) {
                if (!other.getId().equals(sessionId)) continue;
                return other;
            }
        }
        return session;
    }

    private static void removeSessionsWithChangedId() {
        for (Map.Entry entry : SESSION_MAP_BY_ID.entrySet()) {
            HttpSession other;
            String id = (String)entry.getKey();
            if (id.equals((other = (HttpSession)entry.getValue()).getId())) continue;
            SESSION_MAP_BY_ID.remove(id);
        }
    }

    private static void addSession(HttpSession session) {
        SESSION_MAP_BY_ID.put(session.getId(), session);
    }

    private static void removeSession(HttpSession session) {
        HttpSession removedSession = (HttpSession)SESSION_MAP_BY_ID.remove(session.getId());
        if (removedSession == null) {
            SessionListener.removeSessionsWithChangedId();
        }
    }

    public static List<SessionInformations> getAllSessionsInformations() {
        Collection sessions = SESSION_MAP_BY_ID.values();
        ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>(sessions.size());
        for (HttpSession session : sessions) {
            try {
                sessionsInformations.add(new SessionInformations(session, false));
            }
            catch (Exception e) {}
        }
        SessionListener.sortSessions(sessionsInformations);
        return Collections.unmodifiableList(sessionsInformations);
    }

    public static void sortSessions(List<SessionInformations> sessionsInformations) {
        if (sessionsInformations.size() > 1) {
            Collections.sort(sessionsInformations, Collections.reverseOrder(new SessionInformationsComparator()));
        }
    }

    public static SessionInformations getSessionInformationsBySessionId(String sessionId) {
        HttpSession session = SessionListener.getSessionById(sessionId);
        if (session == null) {
            return null;
        }
        try {
            return new SessionInformations(session, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void bindSession(HttpSession session) {
        if (session != null) {
            SESSION_CONTEXT.set(session);
        }
    }

    public static HttpSession getCurrentSession() {
        return SESSION_CONTEXT.get();
    }

    public static void unbindSession() {
        SESSION_CONTEXT.remove();
    }

    public void contextInitialized(ServletContextEvent event) {
        long start = System.currentTimeMillis();
        System.getProperty("java.io.tmpdir");
        String contextPath = Parameters.getContextPath(event.getServletContext());
        if (!this.instanceEnabled) {
            if (!CONTEXT_PATHS.contains(contextPath)) {
                this.instanceEnabled = true;
            } else {
                return;
            }
        }
        CONTEXT_PATHS.add(contextPath);
        Parameters.initialize(event.getServletContext());
        LOG.debug("JavaMelody listener init started");
        JdbcWrapper jdbcWrapper = JdbcWrapper.SINGLETON;
        jdbcWrapper.initServletContext(event.getServletContext());
        if (!Parameters.isNoDatabase()) {
            jdbcWrapper.rebindDataSources();
        }
        long duration = System.currentTimeMillis() - start;
        LOG.debug("JavaMelody listener init done in " + duration + " ms");
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        SESSION_MAP_BY_ID.clear();
        SESSION_COUNT.set(0);
        JdbcWrapper.SINGLETON.stop();
        if (event.getServletContext().getClass().getName().startsWith("io.undertow")) {
            Parameters.initialize((ServletContext)null);
        }
        LOG.debug("JavaMelody listener destroy done");
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        HttpSession session = event.getSession();
        if (session.getAttribute(SESSION_ACTIVATION_KEY) != null) {
            SessionListener.removeSessionsWithChangedId();
        } else {
            session.setAttribute(SESSION_ACTIVATION_KEY, (Object)this);
            SESSION_COUNT.incrementAndGet();
        }
        SessionListener.addSession(session);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        HttpSession session = event.getSession();
        SESSION_COUNT.decrementAndGet();
        SessionListener.removeSession(session);
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        SESSION_COUNT.incrementAndGet();
        SessionListener.addSession(event.getSession());
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (!this.instanceEnabled) {
            return;
        }
        SESSION_COUNT.decrementAndGet();
        SessionListener.removeSession(event.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSessionIfNeeded(HttpSession session) {
        if (session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                if (!SESSION_MAP_BY_ID.containsKey(session.getId())) {
                    this.sessionCreated(new HttpSessionEvent(session));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSessionIfNeeded(HttpSession session) {
        if (session != null) {
            try {
                session.getCreationTime();
                session.getLastAccessedTime();
            }
            catch (IllegalStateException e) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    this.sessionDestroyed(new HttpSessionEvent(session));
                }
            }
        }
    }

    void unregisterInvalidatedSessions() {
        for (Map.Entry entry : SESSION_MAP_BY_ID.entrySet()) {
            HttpSession session = (HttpSession)entry.getValue();
            if (session.getId() != null) {
                this.unregisterSessionIfNeeded(session);
                continue;
            }
            String sessionId = (String)entry.getKey();
            SESSION_MAP_BY_ID.remove(sessionId);
        }
        SESSION_COUNT.set(SESSION_MAP_BY_ID.size());
    }

    void removeAllActivationListeners() {
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            try {
                session.removeAttribute(SESSION_ACTIVATION_KEY);
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[sessionCount=" + SessionListener.getSessionCount() + ']';
    }

    static final class SessionInformationsComparator
    implements Comparator<SessionInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SessionInformationsComparator() {
        }

        @Override
        public int compare(SessionInformations session1, SessionInformations session2) {
            if (session1.getLastAccess().before(session2.getLastAccess())) {
                return 1;
            }
            if (session1.getLastAccess().after(session2.getLastAccess())) {
                return -1;
            }
            return 0;
        }
    }
}

