/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.JCacheInformations;
import net.bull.javamelody.internal.web.html.HtmlJCacheInformationsReport;
import net.bull.javamelody.internal.web.pdf.PdfAbstractTableReport;
import net.bull.javamelody.internal.web.pdf.PdfFonts;

class PdfJCacheInformationsReport
extends PdfAbstractTableReport {
    private final List<JCacheInformations> jcacheInformationsList;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final boolean hitsRatioEnabled;

    PdfJCacheInformationsReport(List<JCacheInformations> jcacheInformationsList, Document document) {
        super(document);
        assert (jcacheInformationsList != null);
        this.jcacheInformationsList = jcacheInformationsList;
        this.hitsRatioEnabled = HtmlJCacheInformationsReport.isHitsRatioEnabled(jcacheInformationsList);
    }

    @Override
    void toPdf() throws DocumentException {
        this.writeHeader();
        for (JCacheInformations jcacheInformations : this.jcacheInformationsList) {
            this.nextRow();
            this.writeCacheInformations(jcacheInformations);
        }
        this.addTableToDocument();
        if (!this.hitsRatioEnabled) {
            Paragraph statisticsEnabledParagraph = new Paragraph(PdfJCacheInformationsReport.getString("jcaches_statistics_enable"), this.cellFont);
            statisticsEnabledParagraph.setAlignment(2);
            this.addToDocument((Element)statisticsEnabledParagraph);
        }
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 4);
        relativeWidths[headers.size() - 1] = 1;
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfJCacheInformationsReport.getString("Cache"));
        if (this.hitsRatioEnabled) {
            headers.add(PdfJCacheInformationsReport.getString("Efficacite_cache"));
        }
        return headers;
    }

    private void writeCacheInformations(JCacheInformations jcacheInformations) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(jcacheInformations.getName());
        if (this.hitsRatioEnabled) {
            defaultCell.setHorizontalAlignment(2);
            this.addCell(this.integerFormat.format(jcacheInformations.getHitsRatio()));
        }
    }
}

