/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.security.SecureRandom;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Base64Coder;

public abstract class HtmlAbstractReport {
    private static final boolean CSRF_PROTECTION_ENABLED = Parameter.CSRF_PROTECTION_ENABLED.getValueAsBoolean();
    private final Writer writer;

    HtmlAbstractReport(Writer writer) {
        assert (writer != null);
        this.writer = writer;
    }

    abstract void toHtml() throws IOException;

    Writer getWriter() {
        return this.writer;
    }

    void writeDirectly(String html) throws IOException {
        this.writer.write(html);
    }

    void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    void writeTitle(String imageFileName, String title) throws IOException {
        this.writeDirectly("<span class='chapterTitle'><img src='?resource=");
        this.writeDirectly(imageFileName);
        this.writeDirectly("' alt=\"");
        this.writeDirectly(title);
        this.writeDirectly("\" />&nbsp;");
        this.writeDirectly("<b>");
        this.writeDirectly(title);
        this.writeDirectly("</b></span><br/>\n");
    }

    void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint' id='" + idToShow + "A'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    static String getString(String key) {
        return I18N.getString(key);
    }

    static String getStringForJavascript(String key) {
        return I18N.getStringForJavascript(key);
    }

    static String getFormattedString(String key, Object ... arguments) {
        return I18N.getFormattedString(key, arguments);
    }

    static String javascriptEncode(String text) {
        return I18N.javascriptEncode(text);
    }

    static String urlEncode(String text) {
        return I18N.urlEncode(text);
    }

    static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    static String htmlEncodeButNotSpace(String text) {
        return I18N.htmlEncode(text, false);
    }

    public static String getCsrfTokenUrlPart() {
        if (CSRF_PROTECTION_ENABLED) {
            HttpSession currentSession = SessionListener.getCurrentSession();
            String csrfToken = (String)currentSession.getAttribute(SessionListener.CSRF_TOKEN_SESSION_NAME);
            if (csrfToken == null) {
                byte[] bytes = new byte[16];
                new SecureRandom().nextBytes(bytes);
                csrfToken = new String(Base64Coder.encode(bytes));
                csrfToken = csrfToken.replace('+', '0').replace('/', '1');
                currentSession.setAttribute(SessionListener.CSRF_TOKEN_SESSION_NAME, (Object)csrfToken);
            }
            return "&amp;" + (Object)((Object)HttpParameter.TOKEN) + '=' + csrfToken;
        }
        return "";
    }

    static boolean isPdfEnabled() {
        return Parameters.isPdfEnabled();
    }

    class HtmlTable {
        private boolean firstRow = true;
        private boolean oddRow;

        HtmlTable() {
        }

        void beginTable(String summary) throws IOException {
            HtmlAbstractReport.this.writeDirectly("<table class='sortable' width='100%' border='1' summary='");
            HtmlAbstractReport.this.writeDirectly(summary);
            HtmlAbstractReport.this.writeDirectly("'>\n");
            HtmlAbstractReport.this.writeDirectly("<thead><tr>");
        }

        void nextRow() throws IOException {
            HtmlAbstractReport.this.writeDirectly("</tr>");
            if (this.firstRow) {
                this.firstRow = false;
                HtmlAbstractReport.this.writeDirectly("</thead><tbody>\n");
            }
            if (this.oddRow) {
                HtmlAbstractReport.this.writeDirectly("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">\n");
            } else {
                HtmlAbstractReport.this.writeDirectly("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">\n");
            }
            this.oddRow = !this.oddRow;
        }

        void endTable() throws IOException {
            HtmlAbstractReport.this.writeDirectly("</tr>");
            if (this.firstRow) {
                this.firstRow = false;
                HtmlAbstractReport.this.writeDirectly("</thead><tbody>\n");
            }
            HtmlAbstractReport.this.writeDirectly("</tbody></table>\n");
        }
    }
}

