/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.LabradorRetriever;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.MavenArtifact;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;

class RemoteCall {
    private final URL url;
    private String cookies;

    RemoteCall(URL url) {
        assert (url != null);
        this.url = url;
    }

    RemoteCall(String url) throws MalformedURLException {
        assert (url != null);
        this.url = url.indexOf(63) == -1 ? new URL(url + "?format=serialized") : new URL(url + "&format=serialized");
    }

    JavaInformations collectJavaInformations() throws IOException {
        URL jvmUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.JVM));
        List list = (List)this.collectForUrl(jvmUrl);
        return (JavaInformations)list.get(0);
    }

    String collectMBeanAttribute(String jmxValueParameter) throws IOException {
        URL mbeanAttributeUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.JMX_VALUE) + '=' + jmxValueParameter);
        return (String)this.collectForUrl(mbeanAttributeUrl);
    }

    double collectGraphLastValue(String graph) throws IOException {
        URL lastValueUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.LAST_VALUE) + '&' + (Object)((Object)HttpParameter.GRAPH) + '=' + graph);
        return (Double)this.collectForUrl(lastValueUrl);
    }

    List<Serializable> collectData() throws IOException {
        return (List)this.collectForUrl(this.url);
    }

    List<Serializable> executeActionAndCollectData(Action action, String counterName, String sessionId, String threadId, String jobId, String cacheId) throws IOException {
        assert (action != null);
        URL actionUrl = this.getActionUrl(action, counterName, sessionId, threadId, jobId, cacheId);
        return (List)this.collectForUrl(actionUrl);
    }

    URL getActionUrl(Action action, String counterName, String sessionId, String threadId, String jobId, String cacheId) throws MalformedURLException {
        StringBuilder actionUrl = new StringBuilder(this.url.toString());
        actionUrl.append("&action=").append((Object)action);
        if (counterName != null) {
            actionUrl.append("&counter=").append(counterName);
        }
        if (sessionId != null) {
            actionUrl.append("&sessionId=").append(sessionId);
        }
        if (threadId != null) {
            actionUrl.append("&threadId=").append(threadId);
        }
        if (jobId != null) {
            actionUrl.append("&jobId=").append(jobId);
        }
        if (cacheId != null) {
            actionUrl.append("&cacheId=").append(cacheId);
        }
        return new URL(actionUrl.toString());
    }

    List<SessionInformations> collectSessionInformations(String sessionId) throws IOException {
        if (sessionId == null) {
            URL sessionsUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.SESSIONS));
            return (List)this.collectForUrl(sessionsUrl);
        }
        URL sessionsUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.SESSIONS) + '&' + (Object)((Object)HttpParameter.SESSION_ID) + '=' + sessionId);
        SessionInformations session = (SessionInformations)this.collectForUrl(sessionsUrl);
        if (session != null) {
            return Collections.singletonList(session);
        }
        return Collections.emptyList();
    }

    List<SamplingProfiler.SampledMethod> collectHotspots() throws IOException {
        URL hotspotsUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.HOTSPOTS));
        return (List)this.collectForUrl(hotspotsUrl);
    }

    HeapHistogram collectHeapHistogram() throws IOException {
        URL heapHistoUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.HEAP_HISTO));
        return (HeapHistogram)this.collectForUrl(heapHistoUrl);
    }

    DatabaseInformations collectDatabaseInformations(int requestIndex) throws IOException {
        URL databaseUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.DATABASE) + '&' + (Object)((Object)HttpParameter.REQUEST) + '=' + requestIndex);
        return (DatabaseInformations)this.collectForUrl(databaseUrl);
    }

    List<List<ConnectionInformations>> collectConnectionInformations() throws IOException {
        ArrayList<List<ConnectionInformations>> connectionInformations = new ArrayList<List<ConnectionInformations>>();
        URL connectionsUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.CONNECTIONS));
        Object result = this.collectForUrl(connectionsUrl);
        if (result instanceof List && !((List)result).isEmpty() && ((List)result).get(0) instanceof List) {
            List connections = (List)result;
            connectionInformations.addAll(connections);
        } else {
            List connections = (List)result;
            connectionInformations.add(connections);
        }
        return connectionInformations;
    }

    Map<String, List<ProcessInformations>> collectProcessInformations() throws IOException {
        String title = I18N.getString("Processus");
        LinkedHashMap<String, List<ProcessInformations>> processesByTitle = new LinkedHashMap<String, List<ProcessInformations>>();
        URL processUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.PROCESSES));
        Object result = this.collectForUrl(processUrl);
        if (result instanceof Map) {
            Map processByTitle = (Map)result;
            for (Map.Entry entry : processByTitle.entrySet()) {
                String node = (String)entry.getKey();
                if (!node.startsWith(title)) {
                    node = title + " (" + (String)entry.getKey() + ')';
                }
                List processList = (List)entry.getValue();
                processesByTitle.put(node, processList);
            }
        } else {
            List processList = (List)result;
            processesByTitle.put(title + " (" + RemoteCall.getHostAndPort(this.url) + ')', processList);
        }
        return processesByTitle;
    }

    List<JndiBinding> collectJndiBindings(String path) throws IOException {
        URL jndiUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.JNDI) + (path != null ? '&' + HttpParameter.PATH.toString() + '=' + path : ""));
        return (List)this.collectForUrl(jndiUrl);
    }

    Map<String, List<MBeanNode>> collectMBeans() throws IOException {
        String title = I18N.getString("MBeans");
        LinkedHashMap<String, List<MBeanNode>> mbeansByTitle = new LinkedHashMap<String, List<MBeanNode>>();
        URL mbeansUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.MBEANS));
        Object result = this.collectForUrl(mbeansUrl);
        if (result instanceof Map) {
            Map mbeansByNodeName = (Map)result;
            for (Map.Entry entry : mbeansByNodeName.entrySet()) {
                String node = (String)entry.getKey();
                if (!node.startsWith(title)) {
                    node = title + " (" + (String)entry.getKey() + ')';
                }
                List mbeans = (List)entry.getValue();
                mbeansByTitle.put(node, mbeans);
            }
        } else {
            List mbeans = (List)result;
            mbeansByTitle.put(title + " (" + RemoteCall.getHostAndPort(this.url) + ')', mbeans);
        }
        return mbeansByTitle;
    }

    Map<String, MavenArtifact> collectWebappDependencies() throws IOException {
        URL dependenciesUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.DEPENDENCIES));
        return (Map)this.collectForUrl(dependenciesUrl);
    }

    Map<String, Date> collectWebappVersions() throws IOException {
        URL webappVersionsUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.WEBAPP_VERSIONS));
        return (Map)this.collectForUrl(webappVersionsUrl);
    }

    Map<JavaInformations, List<CounterRequestContext>> collectCurrentRequests() throws IOException {
        URL currentRequestsUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.CURRENT_REQUESTS));
        return (Map)this.collectForUrl(currentRequestsUrl);
    }

    Map<String, byte[]> collectJRobins(int width, int height) throws IOException {
        URL jrobinNamesUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.JROBINS) + '&' + (Object)((Object)HttpParameter.WIDTH) + '=' + width + '&' + (Object)((Object)HttpParameter.HEIGHT) + '=' + height);
        return (Map)this.collectForUrl(jrobinNamesUrl);
    }

    Map<String, byte[]> collectOtherJRobins(int width, int height) throws IOException {
        URL otherJRobinNamesUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.OTHER_JROBINS) + '&' + (Object)((Object)HttpParameter.WIDTH) + '=' + width + '&' + (Object)((Object)HttpParameter.HEIGHT) + '=' + height);
        return (Map)this.collectForUrl(otherJRobinNamesUrl);
    }

    byte[] collectJRobin(String graphName, int width, int height) throws IOException {
        URL jrobinUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.GRAPH) + '=' + graphName + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.JROBINS) + '&' + (Object)((Object)HttpParameter.WIDTH) + '=' + width + '&' + (Object)((Object)HttpParameter.HEIGHT) + '=' + height);
        return (byte[])this.collectForUrl(jrobinUrl);
    }

    String collectSqlRequestExplainPlan(String sqlRequest) throws IOException {
        URL explainPlanUrl = new URL(this.url.toString() + '&' + (Object)((Object)HttpParameter.PART) + '=' + (Object)((Object)HttpPart.EXPLAIN_PLAN));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HttpParameter.REQUEST.getName(), sqlRequest);
        if (this.cookies != null) {
            headers.put("Cookie", this.cookies);
        }
        LabradorRetriever labradorRetriever = new LabradorRetriever(explainPlanUrl, headers);
        return (String)labradorRetriever.call();
    }

    private <T> T collectForUrl(URL myUrl) throws IOException {
        LabradorRetriever labradorRetriever;
        if (this.cookies != null) {
            Map<String, String> headers = Collections.singletonMap("Cookie", this.cookies);
            labradorRetriever = new LabradorRetriever(myUrl, headers);
        } else {
            labradorRetriever = new LabradorRetriever(myUrl);
        }
        return labradorRetriever.call();
    }

    static String getHostAndPort(URL url) {
        if (url.getPort() != -1) {
            return url.getHost() + ':' + url.getPort();
        }
        return url.getHost();
    }

    URL getURL() {
        return this.url;
    }

    void setCookies(String cookies) {
        this.cookies = cookies;
    }
}

