/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.servlet.http.PushBuilder;

public interface HttpServletRequest
extends ServletRequest {
    public static final String BASIC_AUTH = "BASIC";
    public static final String FORM_AUTH = "FORM";
    public static final String CLIENT_CERT_AUTH = "CLIENT_CERT";
    public static final String DIGEST_AUTH = "DIGEST";

    public String getAuthType();

    public Cookie[] getCookies();

    public long getDateHeader(String var1);

    public String getHeader(String var1);

    public Enumeration<String> getHeaders(String var1);

    public Enumeration<String> getHeaderNames();

    public int getIntHeader(String var1);

    public String getMethod();

    public String getPathInfo();

    public String getPathTranslated();

    default public PushBuilder getPushBuilder() {
        return new NoOpPushBuilder();
    }

    public String getContextPath();

    public String getQueryString();

    public String getRemoteUser();

    public boolean isUserInRole(String var1);

    public Principal getUserPrincipal();

    public String getRequestedSessionId();

    public String getRequestURI();

    public StringBuffer getRequestURL();

    public String getServletPath();

    public HttpSession getSession(boolean var1);

    public HttpSession getSession();

    public String changeSessionId();

    public boolean isRequestedSessionIdValid();

    public boolean isRequestedSessionIdFromCookie();

    public boolean isRequestedSessionIdFromURL();

    @Deprecated
    public boolean isRequestedSessionIdFromUrl();

    public boolean authenticate(HttpServletResponse var1) throws IOException, ServletException;

    public void login(String var1, String var2) throws ServletException;

    public void logout() throws ServletException;

    public Collection<Part> getParts() throws IOException, ServletException;

    public Part getPart(String var1) throws IOException, ServletException;

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> var1) throws IOException, ServletException;

    public static class NoOpPushBuilder
    implements PushBuilder {
        @Override
        public PushBuilder method(String method) {
            return this;
        }

        @Override
        public PushBuilder queryString(String queryString) {
            return this;
        }

        @Override
        public PushBuilder sessionId(String sessionId) {
            return this;
        }

        @Override
        public PushBuilder conditional(boolean conditional) {
            return this;
        }

        @Override
        public PushBuilder setHeader(String name, String value) {
            return this;
        }

        @Override
        public PushBuilder addHeader(String name, String value) {
            return this;
        }

        @Override
        public PushBuilder removeHeader(String name) {
            return this;
        }

        @Override
        public PushBuilder path(String path) {
            return this;
        }

        @Override
        public PushBuilder etag(String etag) {
            return this;
        }

        @Override
        public PushBuilder lastModified(String lastModified) {
            return this;
        }

        @Override
        public void push() {
        }

        @Override
        public String getMethod() {
            return "";
        }

        @Override
        public String getQueryString() {
            return "";
        }

        @Override
        public String getSessionId() {
            return "";
        }

        @Override
        public boolean isConditional() {
            return false;
        }

        @Override
        public Set<String> getHeaderNames() {
            return Collections.emptySet();
        }

        @Override
        public String getHeader(String name) {
            return "";
        }

        @Override
        public String getPath() {
            return "";
        }

        @Override
        public String getEtag() {
            return "";
        }

        @Override
        public String getLastModified() {
            return "";
        }
    }
}

