/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.util.ui;

import java.beans.ConstructorProperties;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class UserNotification {
    protected final String text;
    protected final String caption;

    @Nonnull
    public static UserNotification notification() {
        return new UserNotification("", "");
    }

    @Nonnull
    public UserNotification withCaption(@Nonnull String caption) {
        return new UserNotification(this.text, caption);
    }

    @Nonnull
    public UserNotification withText(@Nonnull String text) {
        return new UserNotification(text, this.caption);
    }

    @Nonnull
    public UserNotification withCaption(@Nonnull Class<?> bundleClass, @Nonnull String resourceName, Object ... params) {
        return new UserNotification(this.text, NbBundle.getMessage(bundleClass, (String)resourceName, (Object[])params));
    }

    @Nonnull
    public UserNotification withText(@Nonnull Class<?> bundleClass, @Nonnull String resourceName, Object ... params) {
        return new UserNotification(NbBundle.getMessage(bundleClass, (String)resourceName, (Object[])params), this.caption);
    }

    @ConstructorProperties(value={"text", "caption"})
    protected UserNotification(String text, String caption) {
        this.text = text;
        this.caption = caption;
    }

    public String toString() {
        return "UserNotification(text=" + this.getText() + ", caption=" + this.getCaption() + ")";
    }

    public String getText() {
        return this.text;
    }

    public String getCaption() {
        return this.caption;
    }
}

