/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.util;

import it.tidalwave.util.Key;
import it.tidalwave.util.TypeSafeMultiMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class TypeSafeHashMultiMap
implements TypeSafeMultiMap,
Serializable {
    @Nonnull
    private final Map<Key<?>, Collection<?>> map;

    public TypeSafeHashMultiMap(@Nonnull Map<Key<?>, Collection<?>> map) {
        this(new HashMap(), true);
        this.map.putAll(map);
    }

    TypeSafeHashMultiMap(@Nonnull Map<Key<?>, Collection<?>> map, boolean dummy) {
        this.map = map;
    }

    @Override
    @Nonnull
    public <T> Collection<T> get(@Nonnull Key<T> key) {
        return this.containsKey(key) ? Collections.unmodifiableCollection(this.map.get(key)) : Collections.emptyList();
    }

    @Override
    public boolean containsKey(@Nonnull Key<?> key) {
        return this.map.containsKey(key);
    }

    @Override
    @Nonnull
    public Set<Key<?>> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.map.size();
    }

    @Override
    @Nonnull
    public Iterator<Collection<?>> iterator() {
        return Collections.unmodifiableCollection(this.map.values()).iterator();
    }

    @Nonnull
    public Map<Key<?>, Collection<?>> asMap() {
        return new HashMap(this.map);
    }

    @Nonnull
    public String toString() {
        return this.map.toString();
    }
}

