/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.role.spi;

import it.tidalwave.role.MutableLocalizedDisplayable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMutableDisplayable
implements MutableLocalizedDisplayable {
    private static final long serialVersionUID = 45345436345634734L;
    @Nonnull
    private final String toStringName;
    @Nonnull
    private final Map<Locale, String> displayNameMap = new HashMap<Locale, String>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Locale defaultLocale = Locale.ENGLISH;

    public DefaultMutableDisplayable(@Nonnull String displayName) {
        this(displayName, "???");
    }

    public DefaultMutableDisplayable(@Nonnull String displayName, @Nonnull String toStringName) {
        this.toStringName = toStringName;
        this.displayNameMap.put(this.defaultLocale, displayName);
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.getDisplayName(this.defaultLocale);
    }

    @Override
    @Nonnull
    public String getDisplayName(@Nonnull Locale locale) {
        return this.displayNameMap.get(locale);
    }

    @Override
    @Nonnull
    public SortedSet<Locale> getLocales() {
        return new TreeSet<Locale>(this.displayNameMap.keySet());
    }

    @Override
    @Nonnull
    public Map<Locale, String> getDisplayNames() {
        return Collections.unmodifiableMap(this.displayNameMap);
    }

    @Override
    public void setDisplayName(@Nonnull String displayName) {
        String oldDisplayName = this.getDisplayName(this.defaultLocale);
        this.setDisplayName(displayName, this.defaultLocale);
        this.pcs.firePropertyChange("displayName", oldDisplayName, displayName);
    }

    @Override
    public void setDisplayName(@Nonnull String displayName, @Nonnull Locale locale) {
        HashMap<Locale, String> oldDisplayNameMap = new HashMap<Locale, String>(this.displayNameMap);
        this.displayNameMap.put(locale, displayName);
        this.pcs.firePropertyChange("displayNames", oldDisplayNameMap, this.displayNameMap);
    }

    @Override
    public void setDisplayNames(@Nonnull Map<Locale, String> displayNames) {
        HashMap<Locale, String> oldDisplayNameMap = new HashMap<Locale, String>(this.displayNameMap);
        this.displayNameMap.putAll(displayNames);
        this.pcs.firePropertyChange("displayNames", oldDisplayNameMap, this.displayNameMap);
    }

    @Override
    public void addPropertyChangeListener(@Nonnull PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@Nonnull PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Nonnull
    public String toString() {
        return String.format("%s@%x$MutableDisplayable[]", this.toStringName, System.identityHashCode(this));
    }
}

