/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet;

import io.undertow.servlet.UndertowServletLogger;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class UndertowServletLogger_$logger
extends DelegatingBasicLogger
implements UndertowServletLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowServletLogger_$logger.class.getName();
    private static final String ioExceptionHandingRequest = "UT015000: IOException handling request";
    private static final String servletExceptionHandlingRequest = "UT015001: ServletException handling request";
    private static final String stoppingServletDueToPermanentUnavailability = "UT015002: Stopping servlet %s due to permanent unavailability";
    private static final String stoppingServletUntilDueToTemporaryUnavailability = "UT015003: Stopping servlet %s till %s due to temporary unavailability";
    private static final String malformedUrlException = "UT015004: Malformed URL exception reading resource %s";
    private static final String errorInvokingListener = "UT015005: Error invoking method %s on listener %s";
    private static final String ioExceptionDispatchingAsyncEvent = "UT015006: IOException dispatching async event";
    private static final String servletStackTracesAll = "UT015007: Stack trace on error enabled for deployment %s, please do not enable for production use";
    private static final String failedtoLoadPersistentSessions = "UT015008: Failed to load development mode persistent sessions";
    private static final String failedToPersistSessionAttribute = "UT015009: Failed to persist session attribute %s with value %s for session %s";
    private static final String failedToPersistSessions = "UT015010: Failed to persist sessions";
    private static final String nonStandardFilterMapping = "UT015011: Non standard filter mapping '*' for filter %s. Portable application should use '/*' instead.";
    private static final String errorGeneratingErrorPage = "UT015012: Failed to generate error page %s for original exception: %s. Generating error page resulted in a %s.";
    private static final String errorOpeningRewriteConfiguration = "UT015013: Error opening rewrite configuration";
    private static final String errorReadingRewriteConfiguration = "UT015014: Error reading rewrite configuration";
    private static final String invalidRewriteConfiguration = "UT015015: Error reading rewrite configuration: %s";
    private static final String invalidRewriteMap = "UT015016: Invalid rewrite map class: %s";
    private static final String invalidRewriteFlags2 = "UT015017: Error reading rewrite flags in line %s as %s";
    private static final String invalidRewriteFlags1 = "UT015018: Error reading rewrite flags in line %s";
    private static final String failedToDestroy = "UT015019: Failed to destroy %s";
    private static final String unsecuredMethodsOnPath = "UT015020: Path %s is secured for some HTTP methods, however it is not secured for %s";

    public UndertowServletLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void ioExceptionHandingRequest(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioExceptionHandingRequest$str(), new Object[0]);
    }

    protected String ioExceptionHandingRequest$str() {
        return ioExceptionHandingRequest;
    }

    @Override
    public final void servletExceptionHandlingRequest(ServletException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.servletExceptionHandlingRequest$str(), new Object[0]);
    }

    protected String servletExceptionHandlingRequest$str() {
        return servletExceptionHandlingRequest;
    }

    @Override
    public final void stoppingServletDueToPermanentUnavailability(String servlet, UnavailableException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.stoppingServletDueToPermanentUnavailability$str(), (Object)servlet);
    }

    protected String stoppingServletDueToPermanentUnavailability$str() {
        return stoppingServletDueToPermanentUnavailability;
    }

    @Override
    public final void stoppingServletUntilDueToTemporaryUnavailability(String name, Date till, UnavailableException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.stoppingServletUntilDueToTemporaryUnavailability$str(), (Object)name, (Object)till);
    }

    protected String stoppingServletUntilDueToTemporaryUnavailability$str() {
        return stoppingServletUntilDueToTemporaryUnavailability;
    }

    @Override
    public final void malformedUrlException(String relativePath, MalformedURLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.malformedUrlException$str(), (Object)relativePath);
    }

    protected String malformedUrlException$str() {
        return malformedUrlException;
    }

    public final void errorInvokingListener(String method, Class<? extends Object> listenerClass, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorInvokingListener$str(), (Object)method, listenerClass);
    }

    protected String errorInvokingListener$str() {
        return errorInvokingListener;
    }

    @Override
    public final void ioExceptionDispatchingAsyncEvent(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioExceptionDispatchingAsyncEvent$str(), new Object[0]);
    }

    protected String ioExceptionDispatchingAsyncEvent$str() {
        return ioExceptionDispatchingAsyncEvent;
    }

    @Override
    public final void servletStackTracesAll(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.servletStackTracesAll$str(), (Object)deploymentName);
    }

    protected String servletStackTracesAll$str() {
        return servletStackTracesAll;
    }

    @Override
    public final void failedtoLoadPersistentSessions(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedtoLoadPersistentSessions$str(), new Object[0]);
    }

    protected String failedtoLoadPersistentSessions$str() {
        return failedtoLoadPersistentSessions;
    }

    @Override
    public final void failedToPersistSessionAttribute(String attributeName, Object value, String sessionID, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPersistSessionAttribute$str(), (Object)attributeName, value, (Object)sessionID);
    }

    protected String failedToPersistSessionAttribute$str() {
        return failedToPersistSessionAttribute;
    }

    @Override
    public final void failedToPersistSessions(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPersistSessions$str(), new Object[0]);
    }

    protected String failedToPersistSessions$str() {
        return failedToPersistSessions;
    }

    @Override
    public final void nonStandardFilterMapping(String filterName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.nonStandardFilterMapping$str(), (Object)filterName);
    }

    protected String nonStandardFilterMapping$str() {
        return nonStandardFilterMapping;
    }

    @Override
    public final void errorGeneratingErrorPage(String originalErrorPage, Object originalException, int code, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorGeneratingErrorPage$str(), (Object)originalErrorPage, originalException, (Object)code);
    }

    protected String errorGeneratingErrorPage$str() {
        return errorGeneratingErrorPage;
    }

    protected String errorOpeningRewriteConfiguration$str() {
        return errorOpeningRewriteConfiguration;
    }

    @Override
    public final String errorOpeningRewriteConfiguration() {
        return String.format(this.errorOpeningRewriteConfiguration$str(), new Object[0]);
    }

    @Override
    public final void errorReadingRewriteConfiguration(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorReadingRewriteConfiguration$str(), new Object[0]);
    }

    protected String errorReadingRewriteConfiguration$str() {
        return errorReadingRewriteConfiguration;
    }

    protected String invalidRewriteConfiguration$str() {
        return invalidRewriteConfiguration;
    }

    @Override
    public final IllegalArgumentException invalidRewriteConfiguration(String line) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidRewriteConfiguration$str(), line));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRewriteMap$str() {
        return invalidRewriteMap;
    }

    @Override
    public final IllegalArgumentException invalidRewriteMap(String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidRewriteMap$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRewriteFlags2$str() {
        return invalidRewriteFlags2;
    }

    @Override
    public final IllegalArgumentException invalidRewriteFlags(String line, String flags) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidRewriteFlags2$str(), line, flags));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRewriteFlags1$str() {
        return invalidRewriteFlags1;
    }

    @Override
    public final IllegalArgumentException invalidRewriteFlags(String line) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidRewriteFlags1$str(), line));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void failedToDestroy(Object object, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToDestroy$str(), object);
    }

    protected String failedToDestroy$str() {
        return failedToDestroy;
    }

    @Override
    public final void unsecuredMethodsOnPath(String path, Set<String> missing) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsecuredMethodsOnPath$str(), (Object)path, missing);
    }

    protected String unsecuredMethodsOnPath$str() {
        return unsecuredMethodsOnPath;
    }
}

