/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import io.ultreia.maven.gitlab.model.MilestoneModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ProjectModel {
    private final String issueUrl;
    private final String milestoneUrl;
    private final String title;
    private final String author;
    private final String authorEmail;
    private final List<String> trackers;
    private final List<MilestoneModel> milestones;
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public ProjectModel(String projectUrl, String title, String author, String authorEmail, Set<MilestoneModel> milestones, List<String> trackers) {
        this.milestoneUrl = projectUrl + "/-/milestones";
        this.issueUrl = projectUrl + "/-/issues";
        this.title = title;
        this.author = author;
        this.authorEmail = authorEmail;
        this.trackers = trackers;
        this.milestones = new ArrayList<MilestoneModel>(milestones);
        Collections.reverse(this.milestones);
    }

    public String getNow() {
        return SIMPLE_DATE_FORMAT.format(new Date());
    }

    public String getMilestoneUrl() {
        return this.milestoneUrl;
    }

    public String getIssueUrl() {
        return this.issueUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public List<String> getTrackers() {
        return this.trackers;
    }

    public List<MilestoneModel> getMilestones() {
        return this.milestones;
    }
}

