/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import io.ultreia.maven.gitlab.model.GitlabIssueTime;
import java.util.List;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabUser;

public class IssueModel {
    private final GitlabIssue issue;
    private final GitlabIssueTime time;
    private final String tracker;
    private final String issueType;

    public IssueModel(GitlabIssue issue, GitlabIssueTime time, String tracker, List<String> trackers) {
        this.issue = issue;
        this.time = time;
        String issueType = "unknown";
        int i = trackers.indexOf(tracker);
        switch (i) {
            case 0: {
                issueType = "fix";
                break;
            }
            case 1: {
                issueType = "add";
                break;
            }
            case 2: {
                issueType = "update";
                break;
            }
            case 3: {
                issueType = "remove";
            }
        }
        this.tracker = tracker;
        this.issueType = issueType;
    }

    public IssueModel(GitlabIssue issue, String tracker, List<String> trackers) {
        this(issue, null, tracker, trackers);
    }

    public String getTracker() {
        return this.tracker;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public int getId() {
        return this.issue.getIid();
    }

    public String getTitle() {
        return this.issue.getTitle();
    }

    public GitlabUser getAssignee() {
        return this.issue.getAssignee();
    }

    public GitlabUser getAuthor() {
        return this.issue.getAuthor();
    }

    public int getTimeEstimate() {
        return this.time.getTimeEstimate();
    }

    public int getTotalTimeSpent() {
        return this.time.getTotalTimeSpent();
    }

    public String getHumanTimeEstimate() {
        return this.time.getHumanTimeEstimate();
    }

    public String getHumanTotalTimeSpend() {
        return this.time.getHumanTotalTimeSpend();
    }
}

