/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;

public class GitlabIssueTime {
    public static final String URL = "/issues/%s/time_stats";
    @JsonProperty(value="time_estimate")
    private int timeEstimate;
    @JsonProperty(value="total_time_spent")
    private int totalTimeSpent;
    @JsonProperty(value="human_time_estimate")
    private String humanTimeEstimate;
    @JsonProperty(value="human_total_time_spent")
    private String humanTotalTimeSpend;

    public int getTimeEstimate() {
        return this.timeEstimate;
    }

    public void setTimeEstimate(int timeEstimate) {
        this.timeEstimate = timeEstimate;
    }

    public int getTotalTimeSpent() {
        return this.totalTimeSpent;
    }

    public void setTotalTimeSpent(int totalTimeSpent) {
        this.totalTimeSpent = totalTimeSpent;
    }

    public String getHumanTimeEstimate() {
        return this.humanTimeEstimate;
    }

    public void setHumanTimeEstimate(String humanTimeEstimate) {
        this.humanTimeEstimate = humanTimeEstimate;
    }

    public String getHumanTotalTimeSpend() {
        return this.humanTotalTimeSpend;
    }

    public void setHumanTotalTimeSpend(String humanTotalTimeSpend) {
        this.humanTotalTimeSpend = humanTotalTimeSpend;
    }

    public void add(GitlabIssueTime issueTime, int hoursByDay) {
        long nbHours = TimeUnit.SECONDS.toHours(issueTime.getTimeEstimate());
        long nbDays = nbHours / 8L;
        long totalHours = nbHours % 8L + (long)hoursByDay * nbDays;
        this.timeEstimate = (int)((long)this.timeEstimate + totalHours);
    }

    public void recomputeHumanValues() {
        this.humanTimeEstimate = this.convertTime(this.timeEstimate);
        this.humanTotalTimeSpend = this.convertTime(this.totalTimeSpent);
    }

    private String convertTime(long timeEstimate) {
        return String.format("%dd %dh", timeEstimate / 6L, timeEstimate % 6L);
    }

    public void addEstimateTime(int pm) {
        this.timeEstimate += pm;
    }
}

