/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.model.MilestoneReleaseArtifactModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;
import org.nuiton.version.Versions;

public class GitlabCache {
    private final Path cachePath;
    private final Gson gson;

    GitlabCache(Path cachePath) {
        this.cachePath = cachePath;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public Optional<GitlabProject> getProject() throws IOException {
        Path projectPath = this.cachePath.resolve("project.json");
        if (Files.exists(projectPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(projectPath);){
                GitlabProject gitlabMilestone = (GitlabProject)this.gson.fromJson((Reader)reader, GitlabProject.class);
                Optional<GitlabProject> optional = Optional.of(gitlabMilestone);
                return optional;
            }
        }
        return Optional.empty();
    }

    void setProject(GitlabProject gitlabProject) throws IOException {
        Path projectPath = this.cachePath.resolve("project.json");
        Files.createDirectories(projectPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(projectPath, new OpenOption[0]);){
            this.gson.toJson((Object)gitlabProject, (Appendable)reader);
        }
    }

    Optional<GitlabMilestoneExt> getMilestone(String id) throws IOException {
        Path milestonePath = this.cachePath.resolve("milestones").resolve(id + ".json");
        if (Files.exists(milestonePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(milestonePath);){
                GitlabMilestoneExt gitlabMilestone = (GitlabMilestoneExt)this.gson.fromJson((Reader)reader, GitlabMilestoneExt.class);
                Optional<GitlabMilestoneExt> optional = Optional.of(gitlabMilestone);
                return optional;
            }
        }
        return Optional.empty();
    }

    public List<GitlabMilestoneExt> getMilestones() throws IOException {
        Path milestonesPath = this.cachePath.resolve("milestones");
        Set<Path> paths = this.getPaths(milestonesPath);
        LinkedList<GitlabMilestoneExt> result = new LinkedList<GitlabMilestoneExt>();
        for (Path path : paths) {
            if (path.toFile().getName().endsWith("-issues.json") || path.toFile().getName().endsWith("-artifacts.json")) continue;
            BufferedReader reader = Files.newBufferedReader(path);
            Throwable throwable = null;
            try {
                GitlabMilestoneExt gitlabMilestone = (GitlabMilestoneExt)this.gson.fromJson((Reader)reader, GitlabMilestoneExt.class);
                result.add(gitlabMilestone);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
        result.sort(Comparator.comparing(m -> Versions.valueOf((String)m.getTitle())));
        return result;
    }

    void setMilestone(GitlabMilestone gitlabMilestone) throws IOException {
        Path milestonePath = this.cachePath.resolve("milestones").resolve(gitlabMilestone.getId() + ".json");
        Files.createDirectories(milestonePath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(milestonePath, new OpenOption[0]);){
            this.gson.toJson((Object)gitlabMilestone, (Appendable)reader);
        }
    }

    public Set<GitlabIssue> getMilestoneIssues(GitlabMilestone gitlabMilestone) throws IOException {
        Path issuesPath = this.cachePath.resolve("milestones").resolve(gitlabMilestone.getId() + "-issues.json");
        try (BufferedReader reader = Files.newBufferedReader(issuesPath);){
            Type typeOfT = new TypeToken<Set<GitlabIssue>>(){}.getType();
            Set set = (Set)this.gson.fromJson((Reader)reader, typeOfT);
            return set;
        }
    }

    void setMilestoneIssues(GitlabMilestone gitlabMilestone, Iterable<GitlabIssue> gitlabIssues) throws IOException {
        Path issuesPath = this.cachePath.resolve("milestones").resolve(String.format("%d-issues.json", gitlabMilestone.getId()));
        Files.createDirectories(issuesPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(issuesPath, new OpenOption[0]);){
            this.gson.toJson(gitlabIssues, (Appendable)reader);
        }
    }

    public Set<MilestoneReleaseArtifactModel> getMilestoneArtifacts(GitlabMilestone gitlabMilestone) throws IOException {
        Path artifactsPath = this.cachePath.resolve("milestones").resolve(gitlabMilestone.getId() + "-artifacts.json");
        if (!Files.exists(artifactsPath, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(artifactsPath);){
            Type typeOfT = new TypeToken<Set<MilestoneReleaseArtifactModel>>(){}.getType();
            Set set = (Set)this.gson.fromJson((Reader)reader, typeOfT);
            return set;
        }
    }

    public void setMilestoneArtifacts(GitlabMilestone gitlabMilestone, Iterable<MilestoneReleaseArtifactModel> gitlabArtifacts) throws IOException {
        Path issuesPath = this.cachePath.resolve("milestones").resolve(String.format("%d-artifacts.json", gitlabMilestone.getId()));
        Files.createDirectories(issuesPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(issuesPath, new OpenOption[0]);){
            this.gson.toJson(gitlabArtifacts, (Appendable)reader);
        }
    }

    private Set<Path> getPaths(Path path) throws IOException {
        final LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().endsWith(".json")) {
                    paths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }
}

