/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.github.mustachejava.Mustache;
import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import io.ultreia.maven.gitlab.model.ProjectModel;
import io.ultreia.maven.gitlab.model.ProjectModelBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-changes", defaultPhase=LifecyclePhase.PRE_SITE)
@Execute(goal="download-milestones")
public class GenerateChangesMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(property="gitlab.changesFile", required=true, defaultValue="${project.basedir}/src/changes/changes.xml")
    private File changesFile;
    @Parameter(property="gitlab.changesTitle", required=true)
    private String changesTitle;
    @Parameter(property="gitlab.changesAuthor", required=true)
    private String changesAuthor;
    @Parameter(property="gitlab.changesAuthorEmail", required=true)
    private String changesAuthorEmail;
    @Parameter(property="gitlab.trackers", required=true)
    private String trackers;
    @Parameter(property="gitlab.skip")
    private boolean skip;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    protected void execute(GitlabAPIExt api) throws IOException, ProjectNotFoundException {
        Files.createDirectories(this.changesFile.getParentFile().toPath(), new FileAttribute[0]);
        ProjectModel model = ProjectModelBuilder.create(this).setAuthor(this.changesAuthor).setAuthorEmail(this.changesAuthorEmail).setTitle(this.changesTitle).setTrackers(Arrays.asList(this.trackers.split("\\s*,\\s*"))).setMilestone(this.milestone).build();
        Mustache mustache = this.getMustache("changes.xml.mustache");
        try (BufferedWriter writer = Files.newBufferedWriter(this.changesFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            mustache.execute((Writer)writer, (Object)model).flush();
        }
        this.getLog().info((CharSequence)String.format("changes.xml generated to %s", this.changesFile.getParent()));
    }
}

