/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.plugin.bundle.BundleFormatConverter;

public class StringFormatToMessageFormatConverter
implements BundleFormatConverter {
    private static final Log log = LogFactory.getLog(StringFormatToMessageFormatConverter.class);
    private static Pattern PATTERN = Pattern.compile("%\\$?(\\d?)[^\\s']*");

    @Override
    public String convert(String value) {
        String result;
        Matcher matcher = PATTERN.matcher(value);
        boolean matches = matcher.find();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("> value : %s _ matches ? %s", value, matches));
        }
        if (matches) {
            matcher.reset();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (matcher.find()) {
                String argNumber;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("> match group : %s", matcher.group(0)));
                    log.debug((Object)String.format("> match group for number : %s", matcher.group(1)));
                }
                int nb = StringUtils.isNotEmpty((CharSequence)(argNumber = matcher.group(1))) ? Integer.parseInt(argNumber) - 1 : i;
                matcher.appendReplacement(sb, "\\{" + nb + "\\}");
                ++i;
            }
            matcher.appendTail(sb);
            result = sb.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Result : %s", result));
            }
        } else {
            result = value;
        }
        result = this.escapeQuoteChar(result);
        return result;
    }

    private String escapeQuoteChar(String value) {
        String result = value.replaceAll("'", "''");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Result with ' escape : %s", result));
        }
        return result;
    }
}

