/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.repo;

import io.sundr.SundrException;
import io.sundr.model.AttributeKey;
import io.sundr.model.ClassRef;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefinitionRepository {
    private static DefinitionRepository INSTANCE;
    private static DefinitionRepository SCOPE;
    private final ConcurrentMap<String, TypeDef> definitions = new ConcurrentHashMap<String, TypeDef>();
    private final ConcurrentMap<String, Supplier<TypeDef>> suppliers = new ConcurrentHashMap<String, Supplier<TypeDef>>();
    private Map<String, String> snapshot;

    private DefinitionRepository() {
    }

    public static final synchronized DefinitionRepository getRepository() {
        if (SCOPE != null) {
            return SCOPE;
        }
        if (INSTANCE == null) {
            INSTANCE = new DefinitionRepository();
        }
        return INSTANCE;
    }

    public static DefinitionRepository createRepository() {
        return new DefinitionRepository();
    }

    public static WithRepo withRepository(DefinitionRepository repository) {
        return new WithRepo(repository);
    }

    public static WithRepo withNewRepository() {
        return new WithRepo(new DefinitionRepository());
    }

    public synchronized void registerIfAbsent(String fqcn, Supplier<TypeDef> supplier) {
        if (this.definitions.containsKey(fqcn)) {
            return;
        }
        if (this.suppliers.containsKey(fqcn)) {
            return;
        }
        this.suppliers.put(fqcn, supplier);
    }

    public synchronized void registerIfAbsent(TypeDef definition) {
        if (definition == null) {
            return;
        }
        String fqcn = definition.getFullyQualifiedName();
        this.definitions.putIfAbsent(fqcn, definition);
    }

    public synchronized TypeDef register(TypeDef definition) {
        this.definitions.put(definition.getFullyQualifiedName(), definition);
        return definition;
    }

    public synchronized TypeDef register(TypeDef definition, String ... flags) {
        TypeDefBuilder builder = new TypeDefBuilder(definition);
        for (String flag : flags) {
            builder.addToAttributes(new AttributeKey(flag, Boolean.class), (Object)true);
        }
        return this.register(builder.build());
    }

    public synchronized TypeDef register(TypeDef definition, AttributeKey<Boolean> ... flags) {
        TypeDefBuilder builder = new TypeDefBuilder(definition);
        for (AttributeKey<Boolean> flag : flags) {
            builder.addToAttributes(flag, (Object)true);
        }
        return this.register(builder.build());
    }

    public synchronized Set<TypeDef> getDefinitions(String ... flags) {
        LinkedHashSet<TypeDef> result = new LinkedHashSet<TypeDef>();
        for (TypeDef candidate : this.definitions.values()) {
            boolean matches = true;
            for (String flag : flags) {
                AttributeKey attributeKey = new AttributeKey(flag, Boolean.class);
                if (candidate.hasAttribute(attributeKey) && ((Boolean)candidate.getAttribute(attributeKey)).booleanValue()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableSet(result);
    }

    public synchronized Set<TypeDef> getDefinitions(AttributeKey<Boolean> ... attributeKeys) {
        LinkedHashSet<TypeDef> result = new LinkedHashSet<TypeDef>();
        for (TypeDef candidate : this.definitions.values()) {
            boolean matches = true;
            for (AttributeKey<Boolean> attributeKey : attributeKeys) {
                if (candidate.hasAttribute(attributeKey) && ((Boolean)candidate.getAttribute(attributeKey)).booleanValue()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableSet(result);
    }

    public synchronized boolean hasDefinition(String fullyQualifiedName) {
        return this.definitions.containsKey(fullyQualifiedName) || this.suppliers.containsKey(fullyQualifiedName);
    }

    public TypeDef getDefinition(String fullyQualifiedName) {
        return this.getDefinition(fullyQualifiedName, true);
    }

    public synchronized TypeDef getDefinition(String fullyQualifiedName, boolean computeIfSupplied) {
        TypeDef definition = (TypeDef)this.definitions.get(fullyQualifiedName);
        if (definition != null || !computeIfSupplied) {
            return definition;
        }
        Supplier supplier = (Supplier)this.suppliers.remove(fullyQualifiedName);
        if (supplier != null) {
            TypeDef typeDef = (TypeDef)supplier.get();
            this.definitions.put(fullyQualifiedName, typeDef);
            return typeDef;
        }
        return null;
    }

    public synchronized TypeDef getDefinition(TypeRef type) {
        if (type instanceof ClassRef) {
            return this.getDefinition(((ClassRef)type).getFullyQualifiedName());
        }
        return null;
    }

    public synchronized Collection<TypeDef> getDefinitions() {
        return Stream.concat(this.definitions.keySet().stream(), this.suppliers.keySet().stream()).distinct().map(k -> this.getDefinition((String)k)).collect(Collectors.toSet());
    }

    public synchronized void updateReferenceMap() {
        this.snapshot = this.getReferenceMapInternal();
    }

    public synchronized Map<String, String> getReferenceMap() {
        if (this.snapshot == null) {
            this.snapshot = this.getReferenceMapInternal();
        }
        return this.snapshot;
    }

    private Map<String, String> getReferenceMapInternal() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        ArrayList<ClassRef> refs = new ArrayList<ClassRef>();
        for (TypeDef typeDef : this.getDefinitions()) {
            refs.add(typeDef.toInternalReference());
        }
        Collections.sort(refs, new Comparator<ClassRef>(){

            @Override
            public int compare(ClassRef o1, ClassRef o2) {
                return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            }
        });
        for (ClassRef classRef : refs) {
            String key = classRef.getName();
            if (mapping.containsKey(key)) continue;
            mapping.put(key, classRef.getFullyQualifiedName());
        }
        return mapping;
    }

    public synchronized void clear() {
        this.definitions.clear();
        this.suppliers.clear();
    }

    public static class WithRepo {
        private final DefinitionRepository repository;

        public WithRepo(DefinitionRepository repository) {
            this.repository = repository;
        }

        public synchronized <V> V apply(Function<DefinitionRepository, V> function) {
            try {
                SCOPE = this.repository;
                V v = function.apply(this.repository);
                return v;
            }
            catch (Exception e) {
                throw new SundrException((Throwable)e);
            }
            finally {
                SCOPE = null;
            }
        }

        public synchronized <V> V call(Callable<V> callable) {
            try {
                SCOPE = this.repository;
                V v = callable.call();
                return v;
            }
            catch (Exception e) {
                throw new SundrException((Throwable)e);
            }
            finally {
                SCOPE = null;
            }
        }
    }
}

