/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.plugins.ResolvedMethodParameterEquivalence;

class PathAndParametersEquivalence
implements BiPredicate<RequestHandler, RequestHandler> {
    private static final ResolvedMethodParameterEquivalence RESOLVED_METHOD_PARAMETER_EQUIVALENCE = new ResolvedMethodParameterEquivalence();

    PathAndParametersEquivalence() {
    }

    @Override
    public boolean test(RequestHandler a, RequestHandler b) {
        return a.getPatternsCondition().equals(b.getPatternsCondition()) && a.supportedMethods().stream().anyMatch(item -> b.supportedMethods().contains(item)) && a.params().equals(b.params()) && Objects.equals(this.wrapped(a.getParameters()), this.wrapped(b.getParameters()));
    }

    private Set<ResolvedMethodParameterEquivalence.Wrapper> wrapped(List<ResolvedMethodParameter> parameters) {
        return parameters.stream().map(RESOLVED_METHOD_PARAMETER_EQUIVALENCE::wrap).collect(Collectors.toSet());
    }

    public int doHash(RequestHandler requestHandler) {
        return Objects.hash(requestHandler.getPatternsCondition().getPatterns(), requestHandler.supportedMethods(), requestHandler.params(), this.wrapped(requestHandler.getParameters()));
    }

    Wrapper wrap(RequestHandler input) {
        return new Wrapper(input, this);
    }

    public static class Wrapper {
        private final RequestHandler requestHandler;
        private final PathAndParametersEquivalence equivalence;

        Wrapper(RequestHandler requestHandler, PathAndParametersEquivalence equivalence) {
            this.requestHandler = requestHandler;
            this.equivalence = equivalence;
        }

        public int hashCode() {
            return this.equivalence.doHash(this.requestHandler);
        }

        public boolean equals(Object other) {
            return this.equivalence.equals(((Wrapper)other).equivalence) && this.equivalence.test(this.requestHandler, ((Wrapper)other).requestHandler);
        }

        public RequestHandler get() {
            return this.requestHandler;
        }
    }
}

