/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.elementdesc.MemberInfo;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRMET", length=5)
public interface SmallRyeMetricsLogging {
    public static final SmallRyeMetricsLogging log = (SmallRyeMetricsLogging)Logger.getMessageLogger(SmallRyeMetricsLogging.class, (String)SmallRyeMetricsLogging.class.getPackage().getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1000, value="Unable to detect version of SmallRye Metrics")
    public void unableToDetectVersion();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1001, value="MicroProfile: Metrics activated (SmallRye Metrics version: %s)")
    public void logSmallRyeMetricsVersion(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1100, value="Metric producer field discovered: %s")
    public void producerFieldDiscovered(AnnotatedField<?> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1101, value="Metric producer method discovered: %s")
    public void producerMethodDiscovered(AnnotatedMethod<?> var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1102, value="Matching member %s to metric ID=%s and type=%s")
    public void matchingMemberToMetric(MemberInfo var1, MetricID var2, MetricType var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1103, value="Name [%s] did not contain any placeholders or tags, no replacement will be done, check the configuration")
    public void nameDoesNotContainPlaceHoldersOrTags(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1200, value="Register metric [metricId: %s, type: %s]")
    public void registerMetric(MetricID var1, MetricType var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1201, value="Register metric [metricId: %s, type: %s, origin: %s]")
    public void registerMetric(MetricID var1, MetricType var2, Object var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1202, value="Removing metrics with [name: %s]")
    public void removeMetricsByName(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1203, value="Removing metric with [id: %s]")
    public void removeMetricsById(MetricID var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1204, value="Remove metadata for [name: %s]")
    public void removeMetadata(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1300, value="Unable to export metric %s")
    public void unableToExport(String var1, @Cause Exception var2);
}

