/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.metrics.MetricConstants;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MetricsProvider {
    @Inject
    @RegistryType(type=MetricRegistry.Type.BASE)
    Provider<MetricRegistry> registry;
    @Inject
    @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true")
    boolean metricsEnabled;

    public MetricsRecorder create(FaultToleranceOperation operation) {
        if (this.metricsEnabled) {
            return new MetricsRecorderImpl((MetricRegistry)this.registry.get(), operation);
        }
        return MetricsRecorder.NOOP;
    }

    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    private static class MetricsRecorderImpl
    implements MetricsRecorder {
        private final MetricRegistry registry;
        private final Tag methodTag;

        MetricsRecorderImpl(MetricRegistry registry, FaultToleranceOperation operation) {
            this.registry = registry;
            String methodName = operation.getBeanClass().getCanonicalName() + "." + operation.getMethod().getName();
            this.methodTag = new Tag("method", methodName);
            this.registerMetrics(operation);
        }

        private void registerMetrics(FaultToleranceOperation operation) {
            if (operation.hasFallback()) {
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, MetricConstants.RESULT_VALUE_RETURNED, MetricConstants.FALLBACK_NOT_APPLIED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, MetricConstants.RESULT_VALUE_RETURNED, MetricConstants.FALLBACK_APPLIED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, MetricConstants.RESULT_EXCEPTION_THROWN, MetricConstants.FALLBACK_NOT_APPLIED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, MetricConstants.RESULT_EXCEPTION_THROWN, MetricConstants.FALLBACK_APPLIED}).getCount();
            } else {
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, MetricConstants.RESULT_VALUE_RETURNED, MetricConstants.FALLBACK_NOT_DEFINED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, MetricConstants.RESULT_EXCEPTION_THROWN, MetricConstants.FALLBACK_NOT_DEFINED}).getCount();
            }
            if (operation.hasRetry()) {
                this.registry.counter("ft.retry.retries.total", new Tag[]{this.methodTag}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_VALUE_RETURNED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_RETRIES_REACHED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_DURATION_REACHED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_VALUE_RETURNED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_MAX_RETRIES_REACHED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_MAX_DURATION_REACHED}).getCount();
            }
            if (operation.hasTimeout()) {
                this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, MetricConstants.TIMED_OUT_TRUE}).getCount();
                this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, MetricConstants.TIMED_OUT_FALSE}).getCount();
                this.registry.histogram(MetricConstants.TIMEOUT_EXECUTION_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
            }
            if (operation.hasCircuitBreaker()) {
                this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, MetricConstants.CIRCUIT_BREAKER_RESULT_SUCCESS}).getCount();
                this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, MetricConstants.CIRCUIT_BREAKER_RESULT_FAILURE}).getCount();
                this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, MetricConstants.CIRCUIT_BREAKER_RESULT_CB_OPEN}).getCount();
                this.registry.counter("ft.circuitbreaker.opened.total", new Tag[]{this.methodTag}).getCount();
            }
            if (operation.hasBulkhead()) {
                this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, MetricConstants.BULKHEAD_RESULT_ACCEPTED}).getCount();
                this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, MetricConstants.BULKHEAD_RESULT_REJECTED}).getCount();
                this.registry.histogram(MetricConstants.BULKHEAD_RUNNING_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
                if (operation.isAsync() || operation.isAdditionalAsync()) {
                    this.registry.histogram(MetricConstants.BULKHEAD_WAITING_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
                }
            }
        }

        private void registerGauge(Supplier<Long> supplier, String name, String unit, Tag ... tags) {
            Metadata metadata = Metadata.builder().withName(name).withType(MetricType.GAUGE).withUnit(unit).build();
            this.registry.gauge(metadata, supplier, tags);
        }

        public void executionFinished(boolean succeeded, boolean fallbackDefined, boolean fallbackApplied) {
            Tag resultTag;
            Tag tag = resultTag = succeeded ? MetricConstants.RESULT_VALUE_RETURNED : MetricConstants.RESULT_EXCEPTION_THROWN;
            Tag fallbackTag = fallbackDefined ? (fallbackApplied ? MetricConstants.FALLBACK_APPLIED : MetricConstants.FALLBACK_NOT_APPLIED) : MetricConstants.FALLBACK_NOT_DEFINED;
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, resultTag, fallbackTag}).inc();
        }

        public void retryAttempted() {
            this.registry.counter("ft.retry.retries.total", new Tag[]{this.methodTag}).inc();
        }

        public void retryValueReturned(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_VALUE_RETURNED}).inc();
        }

        public void retryExceptionNotRetryable(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).inc();
        }

        public void retryMaxRetriesReached(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_RETRIES_REACHED}).inc();
        }

        public void retryMaxDurationReached(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_DURATION_REACHED}).inc();
        }

        public void timeoutFinished(boolean timedOut, long time) {
            this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, timedOut ? MetricConstants.TIMED_OUT_TRUE : MetricConstants.TIMED_OUT_FALSE}).inc();
            this.registry.histogram(MetricConstants.TIMEOUT_EXECUTION_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
        }

        public void circuitBreakerFinished(CircuitBreakerEvents.Result result) {
            Tag circuitBreakerResultTag = null;
            switch (result) {
                case SUCCESS: {
                    circuitBreakerResultTag = MetricConstants.CIRCUIT_BREAKER_RESULT_SUCCESS;
                    break;
                }
                case FAILURE: {
                    circuitBreakerResultTag = MetricConstants.CIRCUIT_BREAKER_RESULT_FAILURE;
                    break;
                }
                case PREVENTED: {
                    circuitBreakerResultTag = MetricConstants.CIRCUIT_BREAKER_RESULT_CB_OPEN;
                }
            }
            this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, circuitBreakerResultTag}).inc();
        }

        public void circuitBreakerMovedToOpen() {
            this.registry.counter("ft.circuitbreaker.opened.total", new Tag[]{this.methodTag}).inc();
        }

        public void registerCircuitBreakerTimeSpentInClosed(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, MetricConstants.CIRCUIT_BREAKER_STATE_CLOSED);
        }

        public void registerCircuitBreakerTimeSpentInOpen(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, MetricConstants.CIRCUIT_BREAKER_STATE_OPEN);
        }

        public void registerCircuitBreakerTimeSpentInHalfOpen(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, MetricConstants.CIRCUIT_BREAKER_STATE_HALF_OPEN);
        }

        public void bulkheadDecisionMade(boolean accepted) {
            Tag bulkheadResultTag = accepted ? MetricConstants.BULKHEAD_RESULT_ACCEPTED : MetricConstants.BULKHEAD_RESULT_REJECTED;
            this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, bulkheadResultTag}).inc();
        }

        public void registerBulkheadExecutionsRunning(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.bulkhead.executionsRunning", "none", this.methodTag);
        }

        public void registerBulkheadExecutionsWaiting(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.bulkhead.executionsWaiting", "none", this.methodTag);
        }

        public void updateBulkheadRunningDuration(long time) {
            this.registry.histogram(MetricConstants.BULKHEAD_RUNNING_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
        }

        public void updateBulkheadWaitingDuration(long time) {
            this.registry.histogram(MetricConstants.BULKHEAD_WAITING_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
        }
    }
}

