package io.vertx.mutiny.core;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.BiConsumer;
import java.util.Set;

/**
 * This class represents a MultiMap of String keys to a List of String values.
 * <p>
 * It's useful in Vert.x to represent things in Vert.x like HTTP headers and HTTP parameters which allow
 * multiple values for keys.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.MultiMap original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.MultiMap.class)
public class MultiMap implements java.lang.Iterable<Entry<String, String>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<MultiMap> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MultiMap((io.vertx.core.MultiMap) obj),
    MultiMap::getDelegate
  );

  private final io.vertx.core.MultiMap delegate;
  
  public MultiMap(io.vertx.core.MultiMap delegate) {
    this.delegate = delegate;
  }

  public MultiMap(Object delegate) {
    this.delegate = (io.vertx.core.MultiMap)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MultiMap() {
    this.delegate = null;
  }

  public io.vertx.core.MultiMap getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultiMap that = (MultiMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public java.util.Iterator<Entry<String, String>> iterator() {
    return delegate.iterator();
  }

  @CheckReturnValue
  public Multi<Entry<String, String>> toMulti() {
    return Multi.createFrom().iterable(this);
  }

  /**
   * @return the multi-map
   */
  public static io.vertx.mutiny.core.MultiMap caseInsensitiveMultiMap() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)io.vertx.core.MultiMap.caseInsensitiveMultiMap());
    return ret;
  }

  /**
   * @param name The name of the header to search
   * @return The first header value or <code>null</code> if there is no such entry
   */
  public String get(String name) { 
    String ret = delegate.get(name);
    return ret;
  }

  /**
   * @param name The name to search
   * @return A immutable {@link java.util.List} of values which will be empty if no values are found
   */
  public List<String> getAll(String name) { 
    List<String> ret = delegate.getAll(name);
    return ret;
  }

  /**
   * @param name The name to search for
   * @return true if at least one entry is found
   */
  public boolean contains(String name) { 
    boolean ret = delegate.contains(name);
    return ret;
  }

  /**
   * @param name the name to search for
   * @param value the value to search for
   * @param caseInsensitive 
   * @return <code>true</code> if at least one entry is found
   */
  public boolean contains(String name, String value, boolean caseInsensitive) { 
    boolean ret = delegate.contains(name, value, caseInsensitive);
    return ret;
  }

  /**
   * @return 
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * @return A {@link java.util.Set} of all names
   */
  public Set<String> names() { 
    Set<String> ret = delegate.names();
    return ret;
  }

  /**
   * @param name The name
   * @param value The value being added
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap add(String name, String value) { 
    delegate.add(name, value);
    return this;
  }

  /**
   * @param map 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap addAll(io.vertx.mutiny.core.MultiMap map) { 
    delegate.addAll(map.getDelegate());
    return this;
  }

  /**
   * @param name The name
   * @param value The value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap set(String name, String value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * @param map 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap setAll(io.vertx.mutiny.core.MultiMap map) { 
    delegate.setAll(map.getDelegate());
    return this;
  }

  /**
   * @param name The name of the value to remove
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap remove(String name) { 
    delegate.remove(name);
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap clear() { 
    delegate.clear();
    return this;
  }

  /**
   * @return 
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public String get(java.lang.CharSequence name) { 
    String ret = delegate.get(name);
    return ret;
  }

  /**
   * @param name 
   * @return 
   */
  public List<String> getAll(java.lang.CharSequence name) { 
    List<String> ret = delegate.getAll(name);
    return ret;
  }

  /**
   * @param action 
   */
  public void forEach(java.util.function.BiConsumer<String, String> action) { 
    delegate.forEach(action);
  }

  /**
   * @return A immutable {@link java.util.List} of the name-value entries, which will be empty if no pairs are found
   */
  public List<java.util.Map.Entry<String, String>> entries() { 
    List<java.util.Map.Entry<String, String>> ret = delegate.entries();
    return ret;
  }

  /**
   * @param name 
   * @return 
   */
  public boolean contains(java.lang.CharSequence name) { 
    boolean ret = delegate.contains(name);
    return ret;
  }

  /**
   * @param name 
   * @param value 
   * @param caseInsensitive 
   * @return 
   */
  public boolean contains(java.lang.CharSequence name, java.lang.CharSequence value, boolean caseInsensitive) { 
    boolean ret = delegate.contains(name, value, caseInsensitive);
    return ret;
  }

  /**
   * @param name 
   * @param value 
   * @return the instance of MultiMap to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap add(java.lang.CharSequence name, java.lang.CharSequence value) { 
    delegate.add(name, value);
    return this;
  }

  /**
   * @param name The name being set
   * @param values The values
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap add(String name, java.lang.Iterable<String> values) { 
    delegate.add(name, values);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return the instance of MultiMap to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap add(java.lang.CharSequence name, java.lang.Iterable<java.lang.CharSequence> values) { 
    delegate.add(name, values);
    return this;
  }

  /**
   * @param headers 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap addAll(java.util.Map<String, String> headers) { 
    delegate.addAll(headers);
    return this;
  }

  /**
   * @param name 
   * @param value 
   * @return the instance of MultiMap to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap set(java.lang.CharSequence name, java.lang.CharSequence value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * @param name The name of the headers being set
   * @param values The values of the headers being set
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap set(String name, java.lang.Iterable<String> values) { 
    delegate.set(name, values);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return the instance of MultiMap to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap set(java.lang.CharSequence name, java.lang.Iterable<java.lang.CharSequence> values) { 
    delegate.set(name, values);
    return this;
  }

  /**
   * @param headers 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap setAll(java.util.Map<String, String> headers) { 
    delegate.setAll(headers);
    return this;
  }

  /**
   * @param name 
   * @return the instance of MultiMap to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.MultiMap remove(java.lang.CharSequence name) { 
    delegate.remove(name);
    return this;
  }

  public static  MultiMap newInstance(io.vertx.core.MultiMap arg) {
    return arg != null ? new MultiMap(arg) : null;
  }

}
