package io.vertx.mutiny.core.parsetools;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A helper class which allows you to easily parse protocols which are delimited by a sequence of bytes, or fixed
 * size records.
 * <p>
 * Instances of this class take as input {@link io.vertx.mutiny.core.buffer.Buffer} instances containing raw bytes,
 * and output records.
 * <p>
 * For example, if I had a simple ASCII text protocol delimited by '\n' and the input was the following:
 * <p>
 * <pre>
 * buffer1:HELLO\nHOW ARE Y
 * buffer2:OU?\nI AM
 * buffer3: DOING OK
 * buffer4:\n
 * </pre>
 * Then the output would be:<p>
 * <pre>
 * buffer1:HELLO
 * buffer2:HOW ARE YOU?
 * buffer3:I AM DOING OK
 * </pre>
 * Instances of this class can be changed between delimited mode and fixed size record mode on the fly as
 * individual records are read, this allows you to parse protocols where, for example, the first 5 records might
 * all be fixed size (of potentially different sizes), followed by some delimited records, followed by more fixed
 * size records.
 * <p>
 * Instances of this class can't currently be used for protocols where the text is encoded with something other than
 * a 1-1 byte-char mapping.
 * <p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.RecordParser original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.parsetools.RecordParser.class)
public class RecordParser implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer>, io.vertx.core.Handler<io.vertx.mutiny.core.buffer.Buffer>, java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RecordParser> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RecordParser((io.vertx.core.parsetools.RecordParser) obj),
    RecordParser::getDelegate
  );

  private final io.vertx.core.parsetools.RecordParser delegate;
  
  public RecordParser(io.vertx.core.parsetools.RecordParser delegate) {
    this.delegate = delegate;
  }

  public RecordParser(Object delegate) {
    this.delegate = (io.vertx.core.parsetools.RecordParser)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RecordParser() {
    this.delegate = null;
  }

  public io.vertx.core.parsetools.RecordParser getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RecordParser that = (RecordParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  private void __setOutput(Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    delegate.setOutput(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
  }

  public void setOutput(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    __setOutput(output != null ? output::accept : null);
  }

  /**
   * @param delim the initial delimiter string
   * @param output handler that will receive the output
   * @return 
   */
  private static io.vertx.mutiny.core.parsetools.RecordParser __newDelimited(String delim, Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim, new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    }));
    return ret;
  }

  /**
   * @param delim the initial delimiter string
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim, java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    return __newDelimited(delim, output != null ? output::accept : null);
  }

  /**
   * @param delim the initial delimiter string
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim, stream.getDelegate()));
    return ret;
  }

  /**
   * @param delim the initial delimiter string
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim, org.reactivestreams.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim, io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * @param delim the initial delimiter string
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim));
    return ret;
  }

  /**
   * @param delim the initial delimiter buffer
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate()));
    return ret;
  }

  /**
   * @param delim the initial delimiter buffer
   * @param output handler that will receive the output
   * @return 
   */
  private static io.vertx.mutiny.core.parsetools.RecordParser __newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    }));
    return ret;
  }

  /**
   * @param delim the initial delimiter buffer
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    return __newDelimited(delim, output != null ? output::accept : null);
  }

  /**
   * @param delim the initial delimiter buffer
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), stream.getDelegate()));
    return ret;
  }

  /**
   * @param delim the initial delimiter buffer
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, org.reactivestreams.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * @param size the initial record size
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size));
    return ret;
  }

  /**
   * @param size the initial record size
   * @param output handler that will receive the output
   * @return 
   */
  private static io.vertx.mutiny.core.parsetools.RecordParser __newFixed(int size, Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size, new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    }));
    return ret;
  }

  /**
   * @param size the initial record size
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size, java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    return __newFixed(size, output != null ? output::accept : null);
  }

  /**
   * @param size the initial record size
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size, stream.getDelegate()));
    return ret;
  }

  /**
   * @param size the initial record size
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size, org.reactivestreams.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance((io.vertx.core.parsetools.RecordParser)io.vertx.core.parsetools.RecordParser.newFixed(size, io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * @param delim the new delimeter
   */
  public void delimitedMode(String delim) { 
    delegate.delimitedMode(delim);
  }

  /**
   * @param delim the new delimiter
   */
  public void delimitedMode(io.vertx.mutiny.core.buffer.Buffer delim) { 
    delegate.delimitedMode(delim.getDelegate());
  }

  /**
   * @param size the new record size
   */
  public void fixedSizeMode(int size) { 
    delegate.fixedSizeMode(size);
  }

  /**
   * @param size the maximum record size
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.parsetools.RecordParser maxRecordSize(int size) { 
    delegate.maxRecordSize(size);
    return this;
  }

  /**
   * @param buffer a chunk of data
   */
  public void handle(io.vertx.mutiny.core.buffer.Buffer buffer) { 
    delegate.handle(buffer.getDelegate());
  }

  @Fluent
  private io.vertx.mutiny.core.parsetools.RecordParser __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  @Fluent
  private io.vertx.mutiny.core.parsetools.RecordParser __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser handler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  @Fluent
  public io.vertx.mutiny.core.parsetools.RecordParser pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.parsetools.RecordParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.parsetools.RecordParser resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.parsetools.RecordParser __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public void accept(io.vertx.mutiny.core.buffer.Buffer item) {
    handle(item);
  }
  public static  RecordParser newInstance(io.vertx.core.parsetools.RecordParser arg) {
    return arg != null ? new RecordParser(arg) : null;
  }

}
