package io.vertx.mutiny.core;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A timeout stream is triggered by a timer, the {@link io.vertx.core.Handler} will be call when the timer is fired,
 * it can be once or several times depending on the nature of the timer related to this stream. The
 *  will be called after the timer handler has been called.
 * <p>
 * Pausing the timer inhibits the timer shots until the stream is resumed. Setting a null handler callback cancels
 * the timer.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.TimeoutStream original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.TimeoutStream.class)
public class TimeoutStream implements io.vertx.mutiny.core.streams.ReadStream<Long> {

  public static final io.smallrye.mutiny.vertx.TypeArg<TimeoutStream> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new TimeoutStream((io.vertx.core.TimeoutStream) obj),
    TimeoutStream::getDelegate
  );

  private final io.vertx.core.TimeoutStream delegate;
  
  public TimeoutStream(io.vertx.core.TimeoutStream delegate) {
    this.delegate = delegate;
  }

  public TimeoutStream(Object delegate) {
    this.delegate = (io.vertx.core.TimeoutStream)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  TimeoutStream() {
    this.delegate = null;
  }

  public io.vertx.core.TimeoutStream getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeoutStream that = (TimeoutStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<Long> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<Long> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<Long> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<java.lang.Long>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<Long> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<java.lang.Long>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<java.lang.Long>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<java.lang.Long>)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<Long> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.core.TimeoutStream __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.TimeoutStream exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  @Fluent
  private io.vertx.mutiny.core.TimeoutStream __handler(Handler<Long> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.mutiny.core.TimeoutStream handler(java.util.function.Consumer<Long> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  @Fluent
  public io.vertx.mutiny.core.TimeoutStream pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.TimeoutStream resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.TimeoutStream fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.TimeoutStream __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.TimeoutStream endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   */
  public void cancel() { 
    delegate.cancel();
  }

  private Multi<Long> multi;
  public synchronized Multi<Long> toMulti() {
    if (multi == null) {
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(this.getDelegate());    }
    return multi;
  }

  public java.lang.Iterable<Long> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<Long> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static  TimeoutStream newInstance(io.vertx.core.TimeoutStream arg) {
    return arg != null ? new TimeoutStream(arg) : null;
  }

}
