package io.vertx.mutiny.core.parsetools;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.time.Instant;
import io.vertx.core.json.JsonArray;
import io.vertx.core.parsetools.JsonEventType;
import io.vertx.core.json.JsonObject;
import com.fasterxml.jackson.core.type.TypeReference;

/**
 * A JSON event emited by the {@link io.vertx.mutiny.core.parsetools.JsonParser}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonEvent original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.parsetools.JsonEvent.class)
public class JsonEvent {

  public static final io.smallrye.mutiny.vertx.TypeArg<JsonEvent> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JsonEvent((io.vertx.core.parsetools.JsonEvent) obj),
    JsonEvent::getDelegate
  );

  private final io.vertx.core.parsetools.JsonEvent delegate;
  
  public JsonEvent(io.vertx.core.parsetools.JsonEvent delegate) {
    this.delegate = delegate;
  }

  public JsonEvent(Object delegate) {
    this.delegate = (io.vertx.core.parsetools.JsonEvent)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JsonEvent() {
    this.delegate = null;
  }

  public io.vertx.core.parsetools.JsonEvent getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonEvent that = (JsonEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the type of the event
   */
  public io.vertx.core.parsetools.JsonEventType type() { 
    io.vertx.core.parsetools.JsonEventType ret = delegate.type();
    return ret;
  }

  /**
   * @return the name of the field when the event is emitted as a JSON object member
   */
  public String fieldName() { 
    String ret = delegate.fieldName();
    return ret;
  }

  /**
   * @return the json value for  events
   */
  public java.lang.Object value() { 
    java.lang.Object ret = (Object) delegate.value();
    return ret;
  }

  /**
   * @return true when the JSON value is a number
   */
  public boolean isNumber() { 
    boolean ret = delegate.isNumber();
    return ret;
  }

  /**
   * @return the <code>Integer</code> value or <code>null</code> if the event has no JSON value
   */
  public Integer integerValue() { 
    Integer ret = delegate.integerValue();
    return ret;
  }

  /**
   * @return the <code>Long</code> value or <code>null</code> if the event has no JSON value
   */
  public Long longValue() { 
    Long ret = delegate.longValue();
    return ret;
  }

  /**
   * @return the <code>Float</code> value or <code>null</code> if the event has no JSON value
   */
  public Float floatValue() { 
    Float ret = delegate.floatValue();
    return ret;
  }

  /**
   * @return the <code>Double</code> value or <code>null</code> if the event has no JSON value
   */
  public Double doubleValue() { 
    Double ret = delegate.doubleValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a boolean
   */
  public boolean isBoolean() { 
    boolean ret = delegate.isBoolean();
    return ret;
  }

  /**
   * @return the <code>Boolean</code> value or <code>null</code> if the event has no JSON value
   */
  public Boolean booleanValue() { 
    Boolean ret = delegate.booleanValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a string
   */
  public boolean isString() { 
    boolean ret = delegate.isString();
    return ret;
  }

  /**
   * @return the string value or <code>null</code> if the event has no JSON value
   */
  public String stringValue() { 
    String ret = delegate.stringValue();
    return ret;
  }

  /**
   * @return the binary value or <code>null</code> if the event has no JSON value
   */
  public io.vertx.mutiny.core.buffer.Buffer binaryValue() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.binaryValue());
    return ret;
  }

  /**
   * @return true when the JSON value is null
   */
  public boolean isNull() { 
    boolean ret = delegate.isNull();
    return ret;
  }

  /**
   * @return true when the JSON value is a JSON object
   */
  public boolean isObject() { 
    boolean ret = delegate.isObject();
    return ret;
  }

  /**
   * @return the JSON object value or <code>null</code> if the event has no JSON value
   */
  public JsonObject objectValue() { 
    JsonObject ret = delegate.objectValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a JSON array
   */
  public boolean isArray() { 
    boolean ret = delegate.isArray();
    return ret;
  }

  /**
   * @return the JSON array value or <code>null</code> if the event has no JSON value
   */
  public JsonArray arrayValue() { 
    JsonArray ret = delegate.arrayValue();
    return ret;
  }

  /**
   * @param type the type to decode the value to
   * @return the decoded value
   */
  public <T> T mapTo(java.lang.Class<T> type) { 
    T ret = (T)io.smallrye.mutiny.vertx.TypeArg.of(type).wrap(delegate.mapTo(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type)));
    return ret;
  }

  /**
   * @return the <code>Instant</code> value or <code>null</code> if the event has no JSON value
   */
  public java.time.Instant instantValue() { 
    java.time.Instant ret = delegate.instantValue();
    return ret;
  }

  /**
   * @param type the type to decode the value to
   * @return the decoded value
   */
  public <T> T mapTo(com.fasterxml.jackson.core.type.TypeReference<T> type) { 
    T ret = (T) delegate.mapTo(type);
    return ret;
  }

  public static  JsonEvent newInstance(io.vertx.core.parsetools.JsonEvent arg) {
    return arg != null ? new JsonEvent(arg) : null;
  }

}
