package io.vertx.mutiny.core.net;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a socket-like interface to a TCP connection on either the
 * client or the server side.
 * <p>
 * Instances of this class are created on the client side by an {@link io.vertx.mutiny.core.net.NetClient}
 * when a connection to a server is made, or on the server side by a {@link io.vertx.mutiny.core.net.NetServer}
 * when a server accepts a connection.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pump} to pump data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetSocket original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.NetSocket.class)
public class NetSocket implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer>, io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<NetSocket> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new NetSocket((io.vertx.core.net.NetSocket) obj),
    NetSocket::getDelegate
  );

  private final io.vertx.core.net.NetSocket delegate;
  
  public NetSocket(io.vertx.core.net.NetSocket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  NetSocket() {    this.delegate = null;
  }

  public io.vertx.core.net.NetSocket getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetSocket that = (NetSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> subscriber;

  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * @param data 
   * @param handler 
   */
  private void __end(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  private io.vertx.mutiny.core.net.NetSocket __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.net.NetSocket __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket handler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.core.net.NetSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @param endHandler 
   * @return 
   */
  private io.vertx.mutiny.core.net.NetSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @param endHandler 
   * @return 
   */
  public io.vertx.mutiny.core.net.NetSocket endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  public io.vertx.mutiny.core.net.NetSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.mutiny.core.net.NetSocket __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.net.NetSocket drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the write handler ID
   */
  public String writeHandlerID() { 
    String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * @param str 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.net.NetSocket __write(String str, Handler<AsyncResult<Void>> handler) { 
    delegate.write(str, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param str 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> write(String str) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(str, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param str 
   * @return the Void instance produced by the operation
   */
  public Void writeAndAwait(String str) { 
    return (Void) write(str).await().indefinitely();
  }

  /**
   * @param str 
   * @param enc 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.net.NetSocket __write(String str, String enc, Handler<AsyncResult<Void>> handler) { 
    delegate.write(str, enc, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param str 
   * @param enc 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> write(String str, String enc) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(str, enc, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param str 
   * @param enc 
   * @return the Void instance produced by the operation
   */
  public Void writeAndAwait(String str, String enc) { 
    return (Void) write(str, enc).await().indefinitely();
  }

  /**
   * @param message 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.net.NetSocket __write(io.vertx.mutiny.core.buffer.Buffer message, Handler<AsyncResult<Void>> handler) { 
    delegate.write(message.getDelegate(), handler);
    return this;
  }

  /**
   * Like  but with an <code>handler</code> called when the message has been written
   * or failed to be written.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param message 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(message, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param message 
   * @return the Void instance produced by the operation
   */
  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer message) { 
    return (Void) write(message).await().indefinitely();
  }

  /**
   * @param filename file name of the file to send
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetSocket __sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, resultHandler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename file name of the file to send
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<Void> sendFile(String filename) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __sendFile(filename, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename file name of the file to send
   * @return a reference to this, so the API can be used fluently
   */
  public Void sendFileAndAwait(String filename) { 
    return (Void) sendFile(filename).await().indefinitely();
  }

  /**
   * @param filename file name of the file to send
   * @param offset offset
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetSocket __sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, resultHandler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename file name of the file to send
   * @param offset offset
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<Void> sendFile(String filename, long offset) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __sendFile(filename, offset, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename file name of the file to send
   * @param offset offset
   * @return a reference to this, so the API can be used fluently
   */
  public Void sendFileAndAwait(String filename, long offset) { 
    return (Void) sendFile(filename, offset).await().indefinitely();
  }

  /**
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetSocket __sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, length, resultHandler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<Void> sendFile(String filename, long offset, long length) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __sendFile(filename, offset, length, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a reference to this, so the API can be used fluently
   */
  public Void sendFileAndAwait(String filename, long offset, long length) { 
    return (Void) sendFile(filename, offset, length).await().indefinitely();
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Calls {@link io.vertx.mutiny.core.net.NetSocket#end}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the NetSocket and notify the <code>handler</code> when the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetSocket#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetSocket __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetSocket __upgradeToSsl(Handler<Void> handler) { 
    delegate.upgradeToSsl(handler);
    return this;
  }

  /**
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket upgradeToSsl(Consumer<Void> handler) {
    return __upgradeToSsl(handler != null ? handler::accept : null);
  }

  /**
   * @param serverName the server name
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetSocket __upgradeToSsl(String serverName, Handler<Void> handler) { 
    delegate.upgradeToSsl(serverName, handler);
    return this;
  }

  /**
   * @param serverName the server name
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket upgradeToSsl(String serverName, Consumer<Void> handler) {
    return __upgradeToSsl(serverName, handler != null ? handler::accept : null);
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.net.NetSocket} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return the indicated server name
   */
  public String indicatedServerName() { 
    String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} but you don't need to compose it with other operations.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  public io.vertx.mutiny.core.net.NetSocket writeAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#write(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#write(String)} but you don't need to compose it with other operations.
   * @param str the string to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket writeAndForget(String str) { 
    delegate.write(str);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#write(String,String)} but you don't need to compose it with other operations.
   * @param str the string to write
   * @param enc the encoding to use
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket writeAndForget(String str, String enc) { 
    delegate.write(str, enc);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String)} but you don't need to compose it with other operations.
   * @param filename file name of the file to send
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket sendFileAndForget(String filename) { 
    delegate.sendFile(filename);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long)} but you don't need to compose it with other operations.
   * @param filename file name of the file to send
   * @param offset offset
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket sendFileAndForget(String filename, long offset) { 
    delegate.sendFile(filename, offset);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#sendFile(String,long,long)} but you don't need to compose it with other operations.
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket sendFileAndForget(String filename, long offset, long length) { 
    delegate.sendFile(filename, offset, length);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    delegate.end();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetSocket#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetSocket#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetSocket#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static  NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
    return arg != null ? new NetSocket(arg) : null;
  }

}
