package io.vertx.mutiny.core.json.pointer;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import java.util.List;
import java.net.URI;

/**
 * Implementation of <a href="https://tools.ietf.org/html/rfc6901">RFC6901 Json Pointers</a>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.json.pointer.JsonPointer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.json.pointer.JsonPointer.class)
public class JsonPointer {

  public static final io.smallrye.mutiny.vertx.TypeArg<JsonPointer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JsonPointer((io.vertx.core.json.pointer.JsonPointer) obj),
    JsonPointer::getDelegate
  );

  private final io.vertx.core.json.pointer.JsonPointer delegate;
  
  public JsonPointer(io.vertx.core.json.pointer.JsonPointer delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  JsonPointer() {    this.delegate = null;
  }

  public io.vertx.core.json.pointer.JsonPointer getDelegate() {
    return delegate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonPointer that = (JsonPointer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public boolean isRootPointer() { 
    boolean ret = delegate.isRootPointer();
    return ret;
  }

  /**
   * @return 
   */
  public boolean isLocalPointer() { 
    boolean ret = delegate.isLocalPointer();
    return ret;
  }

  /**
   * @param child 
   * @return 
   */
  public boolean isParent(io.vertx.mutiny.core.json.pointer.JsonPointer child) { 
    boolean ret = delegate.isParent(child.getDelegate());
    return ret;
  }

  /**
   * @return 
   */
  public String toString() { 
    String ret = delegate.toString();
    return ret;
  }

  /**
   * @param token the unescaped reference token
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.json.pointer.JsonPointer append(String token) { 
    delegate.append(token);
    return this;
  }

  /**
   * @param index 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.json.pointer.JsonPointer append(int index) { 
    delegate.append(index);
    return this;
  }

  /**
   * @param tokens unescaped reference tokens
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.json.pointer.JsonPointer append(List<String> tokens) { 
    delegate.append(tokens);
    return this;
  }

  /**
   * @param pointer other pointer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.json.pointer.JsonPointer append(io.vertx.mutiny.core.json.pointer.JsonPointer pointer) { 
    delegate.append(pointer.getDelegate());
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.json.pointer.JsonPointer parent() { 
    delegate.parent();
    return this;
  }

  /**
   * @param objectToQuery the object to query
   * @param iterator the json pointer iterator that provides the logic to access to the objectToQuery
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object query(Object objectToQuery, io.vertx.mutiny.core.json.pointer.JsonPointerIterator iterator) { 
    Object ret = (Object) delegate.query(objectToQuery, iterator.getDelegate());
    return ret;
  }

  /**
   * @param objectToQuery the object to query
   * @param iterator the json pointer iterator that provides the logic to access to the objectToQuery
   * @param defaultValue default value if query result is null
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object queryOrDefault(Object objectToQuery, io.vertx.mutiny.core.json.pointer.JsonPointerIterator iterator, Object defaultValue) { 
    Object ret = (Object) delegate.queryOrDefault(objectToQuery, iterator.getDelegate(), defaultValue);
    return ret;
  }

  /**
   * @param jsonElement the json element to query
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object queryJson(Object jsonElement) { 
    Object ret = (Object) delegate.queryJson(jsonElement);
    return ret;
  }

  /**
   * @param jsonElement the json element to query
   * @param defaultValue default value if query result is null
   * @return null if pointer points to not existing value, otherwise the requested value
   */
  public Object queryJsonOrDefault(Object jsonElement, Object defaultValue) { 
    Object ret = (Object) delegate.queryJsonOrDefault(jsonElement, defaultValue);
    return ret;
  }

  /**
   * @param objectToQuery the object to query
   * @param iterator the json pointer iterator that provides the logic to access to the objectToQuery
   * @return the stream of walked elements
   */
  public List<Object> tracedQuery(Object objectToQuery, io.vertx.mutiny.core.json.pointer.JsonPointerIterator iterator) { 
    List<Object> ret = delegate.tracedQuery(objectToQuery, iterator.getDelegate());
    return ret;
  }

  /**
   * @param objectToWrite object to write
   * @param iterator the json pointer iterator that provides the logic to access to the objectToMutate
   * @param newElement object to insert
   * @param createOnMissing create objects when missing a object key or an array index
   * @return a reference to objectToWrite if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
   */
  public Object write(Object objectToWrite, io.vertx.mutiny.core.json.pointer.JsonPointerIterator iterator, Object newElement, boolean createOnMissing) { 
    Object ret = (Object) delegate.write(objectToWrite, iterator.getDelegate(), newElement, createOnMissing);
    return ret;
  }

  /**
   * @param jsonElement json element to query and write
   * @param newElement json to insert
   * @return a reference to json if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
   */
  public Object writeJson(Object jsonElement, Object newElement) { 
    Object ret = (Object) delegate.writeJson(jsonElement, newElement);
    return ret;
  }

  /**
   * @param jsonElement json to query and write
   * @param newElement json to insert
   * @param createOnMissing create JsonObject when missing a object key or an array index
   * @return a reference to json if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
   */
  public Object writeJson(Object jsonElement, Object newElement, boolean createOnMissing) { 
    Object ret = (Object) delegate.writeJson(jsonElement, newElement, createOnMissing);
    return ret;
  }

  /**
   * @return a copy of this pointer
   */
  public io.vertx.mutiny.core.json.pointer.JsonPointer copy() { 
    io.vertx.mutiny.core.json.pointer.JsonPointer ret = io.vertx.mutiny.core.json.pointer.JsonPointer.newInstance(delegate.copy());
    return ret;
  }

  /**
   * @return a new empty JsonPointer
   */
  public static io.vertx.mutiny.core.json.pointer.JsonPointer create() { 
    io.vertx.mutiny.core.json.pointer.JsonPointer ret = io.vertx.mutiny.core.json.pointer.JsonPointer.newInstance(io.vertx.core.json.pointer.JsonPointer.create());
    return ret;
  }

  /**
   * @param pointer the string representing a pointer
   * @return new instance of JsonPointer
   */
  public static io.vertx.mutiny.core.json.pointer.JsonPointer from(String pointer) { 
    io.vertx.mutiny.core.json.pointer.JsonPointer ret = io.vertx.mutiny.core.json.pointer.JsonPointer.newInstance(io.vertx.core.json.pointer.JsonPointer.from(pointer));
    return ret;
  }

  /**
   * @return 
   */
  public URI toURI() { 
    URI ret = delegate.toURI();
    return ret;
  }

  /**
   * @return 
   */
  public URI getURIWithoutFragment() { 
    URI ret = delegate.getURIWithoutFragment();
    return ret;
  }

  /**
   * @param uri uri representing a json pointer
   * @return new instance of JsonPointer
   */
  public static io.vertx.mutiny.core.json.pointer.JsonPointer fromURI(URI uri) { 
    io.vertx.mutiny.core.json.pointer.JsonPointer ret = io.vertx.mutiny.core.json.pointer.JsonPointer.newInstance(io.vertx.core.json.pointer.JsonPointer.fromURI(uri));
    return ret;
  }

  public static  JsonPointer newInstance(io.vertx.core.json.pointer.JsonPointer arg) {
    return arg != null ? new JsonPointer(arg) : null;
  }

}
