package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Base WebSocket implementation.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pipe} to pipe data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketBase original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.WebSocketBase.class)
public interface WebSocketBase extends io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer>, io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> {

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  io.vertx.core.http.WebSocketBase getDelegate();

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * @return true if write queue is full
   */
  public boolean writeQueueFull();
  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe();
  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst);
  public io.vertx.mutiny.core.http.WebSocketBase exceptionHandler(Consumer<Throwable> handler);
  public io.vertx.mutiny.core.http.WebSocketBase handler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler);
  public io.vertx.mutiny.core.http.WebSocketBase pause();
  public io.vertx.mutiny.core.http.WebSocketBase resume();
  public io.vertx.mutiny.core.http.WebSocketBase fetch(long amount);
  public io.vertx.mutiny.core.http.WebSocketBase endHandler(Consumer<Void> endHandler);
  public Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data);
  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data);
  public io.vertx.mutiny.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize);
  public io.vertx.mutiny.core.http.WebSocketBase drainHandler(Consumer<Void> handler);
  /**
   * @return the binary handler id
   */
  public String binaryHandlerID();
  /**
   * @return 
   */
  public String textHandlerID();
  /**
   * @return 
   */
  public String subProtocol();
  /**
   * @return 
   */
  public Short closeStatusCode();
  /**
   * @return 
   */
  public String closeReason();
  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers();
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param frame 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param frame 
   * @return the Void instance produced by the operation
   */
  public Void writeFrameAndAwait(io.vertx.mutiny.core.http.WebSocketFrame frame);
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeFinalTextFrame(String text);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation
   */
  public Void writeFinalTextFrameAndAwait(String text);
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void writeFinalBinaryFrameAndAwait(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void writeBinaryMessageAndAwait(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeTextMessage(String text);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation
   */
  public Void writeTextMessageAndAwait(String text);
  /**
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePing(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePong(io.vertx.mutiny.core.buffer.Buffer data);
  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase closeHandler(Consumer<Void> handler);
  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase frameHandler(Consumer<io.vertx.mutiny.core.http.WebSocketFrame> handler);
  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase textMessageHandler(Consumer<String> handler);
  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase binaryMessageHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler);
  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase pongHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler);
  /**
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end();
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait();
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close();
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait();
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(short statusCode);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(short statusCode);
  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @param reason 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(short statusCode, String reason);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @param reason 
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(short statusCode, String reason);
  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress();
  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress();
  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl();
  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed();
  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession();
  public static  WebSocketBase newInstance(io.vertx.core.http.WebSocketBase arg) {
    return arg != null ? new WebSocketBaseImpl(arg) : null;
  }

}

class WebSocketBaseImpl implements WebSocketBase {
  private final io.vertx.core.http.WebSocketBase delegate;
  
  public io.vertx.core.http.WebSocketBase getDelegate() {
    return delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WebSocketBaseImpl() {    this.delegate = null;
  }

  public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
    this.delegate = delegate;
  }

  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  /**
   * @param data 
   * @param handler 
   */
  private void __end(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocketBase __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocketBase __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase handler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.core.http.WebSocketBase pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.mutiny.core.http.WebSocketBase __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocketBase __write(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(data, handler);
    });
  }

  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) write(data).await().indefinitely();
  }

  public io.vertx.mutiny.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.mutiny.core.http.WebSocketBase __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocketBase drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * @return 
   */
  public Short closeStatusCode() { 
    Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * @return 
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * @param frame 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.WebSocketBase __writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param frame 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFrame(frame, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param frame 
   * @return the Void instance produced by the operation
   */
  public Void writeFrameAndAwait(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return (Void) writeFrame(frame).await().indefinitely();
  }

  /**
   * @param text 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.WebSocketBase __writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeFinalTextFrame(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFinalTextFrame(text, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation
   */
  public Void writeFinalTextFrameAndAwait(String text) { 
    return (Void) writeFinalTextFrame(text).await().indefinitely();
  }

  /**
   * @param data 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.WebSocketBase __writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFinalBinaryFrame(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void writeFinalBinaryFrameAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeFinalBinaryFrame(data).await().indefinitely();
  }

  /**
   * @param data 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.WebSocketBase __writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeBinaryMessage(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void writeBinaryMessageAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeBinaryMessage(data).await().indefinitely();
  }

  /**
   * @param text 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.WebSocketBase __writeTextMessage(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param text 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> writeTextMessage(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeTextMessage(text, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param text 
   * @return the Void instance produced by the operation
   */
  public Void writeTextMessageAndAwait(String text) { 
    return (Void) writeTextMessage(text).await().indefinitely();
  }

  /**
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePing(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writePing(data.getDelegate());
    return this;
  }

  /**
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePong(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writePong(data.getDelegate());
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __frameHandler(Handler<io.vertx.mutiny.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(io.vertx.mutiny.core.http.WebSocketFrame.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase frameHandler(Consumer<io.vertx.mutiny.core.http.WebSocketFrame> handler) {
    return __frameHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase textMessageHandler(Consumer<String> handler) {
    return __textMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __binaryMessageHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase binaryMessageHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __binaryMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __pongHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase pongHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __pongHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @param statusCode 
   * @param handler 
   */
  private void __close(short statusCode, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(short statusCode) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(statusCode, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(short statusCode) { 
    return (Void) close(statusCode).await().indefinitely();
  }

  /**
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  private void __close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @param reason 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(short statusCode, String reason) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(statusCode, reason, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @param reason 
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(short statusCode, String reason) { 
    return (Void) close(statusCode, reason).await().indefinitely();
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} but you don't need to compose it with other operations.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  public io.vertx.mutiny.core.http.WebSocketBase writeAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFrame(io.vertx.mutiny.core.http.WebSocketFrame)} but you don't need to compose it with other operations.
   * @param frame the frame to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writeFrameAndForget(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    delegate.writeFrame(frame.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalTextFrame(String)} but you don't need to compose it with other operations.
   * @param text The text to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writeFinalTextFrameAndForget(String text) { 
    delegate.writeFinalTextFrame(text);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data The data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writeFinalBinaryFrameAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writeFinalBinaryFrame(data.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writeBinaryMessageAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writeBinaryMessage(data.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#writeTextMessage(String)} but you don't need to compose it with other operations.
   * @param text the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writeTextMessageAndForget(String text) { 
    delegate.writeTextMessage(text);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    delegate.end();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} but you don't need to compose it with other operations.
   * @param statusCode Status code
   */
  public void closeAndForget(short statusCode) { 
    delegate.close(statusCode);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} but you don't need to compose it with other operations.
   * @param statusCode Status code
   * @param reason reason of closure
   */
  public void closeAndForget(short statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
}
