package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import javax.net.ssl.SSLSession;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents an HTTP connection.
 * <p/>
 * HTTP/1.x connection provides an limited implementation, the following methods are implemented:
 * <ul>
 *   <li>{@link io.vertx.mutiny.core.http.HttpConnection#close}</li>
 *   <li>{@link io.vertx.mutiny.core.http.HttpConnection#closeHandler}</li>
 *   <li>{@link io.vertx.mutiny.core.http.HttpConnection#exceptionHandler}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpConnection.class)
public class HttpConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpConnection((io.vertx.core.http.HttpConnection) obj),
    HttpConnection::getDelegate
  );

  private final io.vertx.core.http.HttpConnection delegate;
  
  public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpConnection() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpConnection that = (HttpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the current connection window size or <code>-1</code> for HTTP/1.x
   */
  public int getWindowSize() { 
    int ret = delegate.getWindowSize();
    return ret;
  }

  /**
   * @param windowSize the new window size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection setWindowSize(int windowSize) { 
    delegate.setWindowSize(windowSize);
    return this;
  }

  /**
   * @param errorCode 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection goAway(long errorCode) { 
    delegate.goAway(errorCode);
    return this;
  }

  /**
   * @param errorCode 
   * @param lastStreamId 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection goAway(long errorCode, int lastStreamId) { 
    delegate.goAway(errorCode, lastStreamId);
    return this;
  }

  /**
   * @param errorCode the  error code
   * @param lastStreamId the last stream id
   * @param debugData additional debug data sent to the remote endpoint
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection goAway(long errorCode, int lastStreamId, io.vertx.mutiny.core.buffer.Buffer debugData) { 
    delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __goAwayHandler(Handler<GoAway> handler) { 
    delegate.goAwayHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection goAwayHandler(Consumer<GoAway> handler) {
    return __goAwayHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __shutdownHandler(Handler<Void> handler) { 
    delegate.shutdownHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection shutdownHandler(Consumer<Void> handler) {
    return __shutdownHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection shutdown() { 
    delegate.shutdown();
    return this;
  }

  /**
   * @param timeoutMs the timeout in milliseconds
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection shutdown(long timeoutMs) { 
    delegate.shutdown(timeoutMs);
    return this;
  }

  /**
   * @param handler the handler to be notified
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler to be notified
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the latest server settings acknowledged by the remote endpoint - this is not implemented for HTTP/1.x
   */
  public Http2Settings settings() { 
    Http2Settings ret = delegate.settings();
    return ret;
  }

  /**
   * @param settings the new settings
   * @param completionHandler the handler notified when the settings have been acknowledged by the remote endpoint
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.updateSettings(settings, completionHandler);
    return this;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param settings the new settings
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<Void> updateSettings(Http2Settings settings) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __updateSettings(settings, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param settings the new settings
   * @return a reference to this, so the API can be used fluently
   */
  public Void updateSettingsAndAwait(Http2Settings settings) { 
    return (Void) updateSettings(settings).await().indefinitely();
  }

  /**
   * @return the current remote endpoint settings for this connection - this is not implemented for HTTP/1.x
   */
  public Http2Settings remoteSettings() { 
    Http2Settings ret = delegate.remoteSettings();
    return ret;
  }

  /**
   * @param handler the handler for remote endpoint settings
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __remoteSettingsHandler(Handler<Http2Settings> handler) { 
    delegate.remoteSettingsHandler(handler);
    return this;
  }

  /**
   * @param handler the handler for remote endpoint settings
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection remoteSettingsHandler(Consumer<Http2Settings> handler) {
    return __remoteSettingsHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param data the 8 bytes data of the frame
   * @param pongHandler an async result handler notified with pong reply or the failure
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __ping(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<io.vertx.mutiny.core.buffer.Buffer>> pongHandler) { 
    delegate.ping(data.getDelegate(), new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          pongHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.buffer.Buffer.newInstance(ar.result())));
        } else {
          pongHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data the 8 bytes data of the frame
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.buffer.Buffer> ping(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __ping(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#ping(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data the 8 bytes data of the frame
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.buffer.Buffer pingAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (io.vertx.mutiny.core.buffer.Buffer) ping(data).await().indefinitely();
  }

  /**
   * @param handler the handler to be called when a  is received
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __pingHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.pingHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler to be called when a  is received
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection pingHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __pingHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpConnection __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return the indicated server name
   */
  public String indicatedServerName() { 
    String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)} but you don't need to compose it with other operations.
   * @param settings the new settings
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpConnection updateSettingsAndForget(Http2Settings settings) { 
    delegate.updateSettings(settings);
    return this;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  public static  HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
    return arg != null ? new HttpConnection(arg) : null;
  }

}
