package io.vertx.mutiny.core;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents the writable side of an action that may, or may not, have occurred yet.
 * <p>
 * The {@link io.vertx.mutiny.core.Promise#future} method returns the {@link io.vertx.mutiny.core.Future} associated with a promise, the future
 * can be used for getting notified of the promise completion and retrieve its value.
 * <p>
 * A promise extends <code>Handler<AsyncResult<T>></code> so it can be used as a callback.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Promise original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.Promise.class)
public class Promise<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<Promise> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Promise((io.vertx.core.Promise) obj),
    Promise::getDelegate
  );

  private final io.vertx.core.Promise<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Promise(io.vertx.core.Promise delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Promise(io.vertx.core.Promise delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Promise() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.Promise getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Promise that = (Promise) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the promise
   */
  public static <T> io.vertx.mutiny.core.Promise<T> promise() { 
    io.vertx.mutiny.core.Promise<T> ret = io.vertx.mutiny.core.Promise.newInstance(io.vertx.core.Promise.promise(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param result the result
   */
  public void complete(T result) { 
    delegate.complete(__typeArg_0.<T>unwrap(result));
  }

  /**
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * @param cause the failure cause
   */
  public void fail(Throwable cause) { 
    delegate.fail(cause);
  }

  /**
   * @param message the failure message
   */
  public void fail(String message) { 
    delegate.fail(message);
  }

  /**
   * @param result the result
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete(T result) { 
    boolean ret = delegate.tryComplete(__typeArg_0.<T>unwrap(result));
    return ret;
  }

  /**
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * @param cause the failure cause
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryFail(Throwable cause) { 
    boolean ret = delegate.tryFail(cause);
    return ret;
  }

  /**
   * @param message the failure message
   * @return false when the future is already completed
   */
  public boolean tryFail(String message) { 
    boolean ret = delegate.tryFail(message);
    return ret;
  }

  /**
   * @return the {@link io.vertx.mutiny.core.Future} associated with this promise, it can be used to be aware of the promise completion
   */
  public io.vertx.mutiny.core.Future<T> future() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.Future<T> ret = io.vertx.mutiny.core.Future.newInstance(delegate.future(), __typeArg_0);
    cached_0 = ret;
    return ret;
  }

  private io.vertx.mutiny.core.Future<T> cached_0;
  public static <T>Promise<T> newInstance(io.vertx.core.Promise arg) {
    return arg != null ? new Promise<T>(arg) : null;
  }


  public static <T>Promise<T> newInstance(io.vertx.core.Promise arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Promise<T>(arg, __typeArg_T) : null;
  }

}
