/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.Functions;
import io.smallrye.config.ConfigMappingClass;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.KeyMap;
import io.smallrye.config.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

final class ConfigMappingProvider
implements Serializable {
    private static final long serialVersionUID = 3977667610888849912L;
    private static final BiConsumer<ConfigMappingContext, NameIterator> DO_NOTHING = Functions.discardingBiConsumer();
    private static final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> IGNORE_EVERYTHING;
    private final Map<String, List<Class<?>>> roots;
    private final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions;
    private final KeyMap<String> defaultValues;
    private final boolean validateUnknown;

    ConfigMappingProvider(Builder builder) {
        this.roots = new HashMap(builder.roots);
        ArrayDeque<String> currentPath = new ArrayDeque<String>();
        KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions = new KeyMap<BiConsumer<ConfigMappingContext, NameIterator>>();
        KeyMap<String> defaultValues = new KeyMap<String>();
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            NameIterator rootNi = new NameIterator(entry.getKey());
            while (rootNi.hasNext()) {
                String nextSegment = rootNi.getNextSegment();
                if (!nextSegment.isEmpty()) {
                    currentPath.add(nextSegment);
                }
                rootNi.next();
            }
            List<Class<?>> roots = entry.getValue();
            for (Class<?> root : roots) {
                GetRootAction ef = new GetRootAction(root, entry.getKey());
                ConfigMappingInterface mapping = ConfigMappingLoader.getConfigMappingInterface(root);
                this.processEagerGroup(currentPath, matchActions, defaultValues, mapping.getNamingStrategy(), mapping, ef);
            }
            currentPath.clear();
        }
        for (String[] ignoredPath : builder.ignored) {
            KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> found;
            int len;
            if (ignoredPath[(len = ignoredPath.length) - 1].equals("**")) {
                found = matchActions.findOrAdd(ignoredPath, 0, len - 1);
                found.putRootValue(DO_NOTHING);
                found.putAny(IGNORE_EVERYTHING);
                continue;
            }
            found = matchActions.findOrAdd(ignoredPath);
            found.putRootValue(DO_NOTHING);
        }
        this.matchActions = matchActions;
        this.defaultValues = defaultValues;
        this.validateUnknown = builder.validateUnknown;
    }

    static String skewer(String camelHumps) {
        return ConfigMappingProvider.skewer(camelHumps, '-');
    }

    static String skewer(String camelHumps, char separator) {
        return ConfigMappingProvider.skewer(camelHumps, 0, camelHumps.length(), new StringBuilder(), separator);
    }

    private static String skewer(String camelHumps, int start, int end, StringBuilder b, char separator) {
        if (camelHumps.isEmpty()) {
            throw new IllegalArgumentException("Method seems to have an empty name");
        }
        int cp = camelHumps.codePointAt(start);
        b.appendCodePoint(Character.toLowerCase(cp));
        if ((start += Character.charCount(cp)) == end) {
            return b.toString();
        }
        if (Character.isUpperCase(cp)) {
            int nextCp = camelHumps.codePointAt(start);
            if (Character.isUpperCase(nextCp)) {
                do {
                    b.appendCodePoint(Character.toLowerCase(nextCp));
                    cp = nextCp;
                    if ((start += Character.charCount(cp)) != end) continue;
                    return b.toString();
                } while (!Character.isLowerCase(nextCp = camelHumps.codePointAt(start)));
                b.append(separator);
                return ConfigMappingProvider.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(nextCp);
            start += Character.charCount(nextCp);
            while (true) {
                if (start == end) {
                    return b.toString();
                }
                cp = camelHumps.codePointAt(start);
                if (Character.isUpperCase(cp)) {
                    b.append(separator);
                    return ConfigMappingProvider.skewer(camelHumps, start, end, b, separator);
                }
                b.appendCodePoint(cp);
                start += Character.charCount(cp);
            }
        }
        do {
            if (Character.isUpperCase(cp = camelHumps.codePointAt(start))) {
                b.append(separator);
                return ConfigMappingProvider.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(cp);
        } while ((start += Character.charCount(cp)) != end);
        return b.toString();
    }

    private void processEagerGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction) {
        Class<?> type = group.getInterfaceType();
        int pc = group.getPropertyCount();
        int pathLen = currentPath.size();
        HashSet<String> usedProperties = new HashSet<String>();
        for (int i = 0; i < pc; ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            String memberName = property.getMethod().getName();
            if (!usedProperties.add(memberName)) continue;
            if (!property.isParentPropertyName()) {
                NameIterator ni = new NameIterator(property.hasPropertyName() ? property.getPropertyName() : (String)namingStrategy.apply(property.getPropertyName()));
                while (ni.hasNext()) {
                    currentPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            this.processProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, property);
            while (currentPath.size() > pathLen) {
                currentPath.removeLast();
            }
        }
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processEagerGroup(currentPath, matchActions, defaultValues, namingStrategy, group.getSuperType(i), getEnclosingFunction);
        }
    }

    private void processProperty(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName, ConfigMappingInterface.Property property) {
        if (property.isOptional()) {
            ConfigMappingInterface.MayBeOptionalProperty nestedProperty = property.asOptional().getNestedProperty();
            this.processOptionalProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, nestedProperty);
        } else if (property.isGroup()) {
            this.processEagerGroup(currentPath, matchActions, defaultValues, namingStrategy, property.asGroup().getGroupType(), new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, property.asGroup(), currentPath));
        } else if (property.isPrimitive()) {
            ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
            if (primitiveProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(primitiveProperty.getDefaultValue());
                }
            }
            matchActions.findOrAdd(currentPath).putRootValue(DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                matchActions.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(DO_NOTHING);
            }
        } else if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            if (leafProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                }
            }
            matchActions.findOrAdd(currentPath).putRootValue(DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                matchActions.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(DO_NOTHING);
            }
        } else if (property.isMap()) {
            this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), getEnclosingFunction, namingStrategy, group);
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, collectionProperty.getElement());
        }
    }

    private void processOptionalProperty(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName, ConfigMappingInterface.Property nestedProperty) {
        if (nestedProperty.isGroup()) {
            ConfigMappingInterface.GroupProperty nestedGroup = nestedProperty.asGroup();
            GetOrCreateEnclosingGroupInGroup matchAction = new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, nestedGroup, currentPath);
            GetFieldOfEnclosing ef = new GetFieldOfEnclosing(nestedGroup.isParentPropertyName() ? getEnclosingFunction : new ConsumeOneAndThenFn<ConfigMappingObject>(getEnclosingFunction), type, memberName);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, nestedGroup.getGroupType(), ef, matchAction, new HashSet<String>());
        } else if (nestedProperty.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = nestedProperty.asLeaf();
            if (leafProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                }
            }
            matchActions.findOrAdd(currentPath).putRootValue(DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                matchActions.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(DO_NOTHING);
            }
        } else if (nestedProperty.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = nestedProperty.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, collectionProperty.getElement());
        }
    }

    private void processLazyGroupInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, BiConsumer<ConfigMappingContext, NameIterator> matchAction, HashSet<String> usedProperties) {
        int pc = group.getPropertyCount();
        int pathLen = currentPath.size();
        for (int i = 0; i < pc; ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            if (!property.isParentPropertyName()) {
                NameIterator ni = new NameIterator(property.hasPropertyName() ? property.getPropertyName() : (String)namingStrategy.apply(property.getPropertyName()));
                while (ni.hasNext()) {
                    currentPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            if (usedProperties.add(property.getMethod().getName())) {
                boolean optional = property.isOptional();
                this.processLazyPropertyInGroup(currentPath, matchActions, defaultValues, getEnclosingFunction, matchAction, usedProperties, namingStrategy, group, optional, property);
            }
            while (currentPath.size() > pathLen) {
                currentPath.removeLast();
            }
        }
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, group.getSuperType(i), getEnclosingFunction, matchAction, usedProperties);
        }
    }

    private void processLazyPropertyInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, BiConsumer<ConfigMappingContext, NameIterator> matchAction, HashSet<String> usedProperties, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, boolean optional, ConfigMappingInterface.Property property) {
        if (optional && property.asOptional().getNestedProperty().isGroup()) {
            ConfigMappingInterface.GroupProperty nestedGroup = property.asOptional().getNestedProperty().asGroup();
            GetOrCreateEnclosingGroupInGroup nestedMatchAction = new GetOrCreateEnclosingGroupInGroup(property.isParentPropertyName() ? getEnclosingFunction : new ConsumeOneAndThenFn<ConfigMappingObject>(getEnclosingFunction), group, nestedGroup, currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, nestedGroup.getGroupType(), nestedMatchAction, nestedMatchAction, new HashSet<String>());
        } else if (property.isGroup()) {
            ConfigMappingInterface.GroupProperty asGroup = property.asGroup();
            GetOrCreateEnclosingGroupInGroup nestedEnclosingFunction = new GetOrCreateEnclosingGroupInGroup((BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>)(property.isParentPropertyName() ? getEnclosingFunction : new ConsumeOneAndThenFn<ConfigMappingObject>(getEnclosingFunction)), group, asGroup, currentPath);
            ConsumeOneAndThen nestedMatchAction = matchAction;
            if (!property.isParentPropertyName()) {
                nestedMatchAction = new ConsumeOneAndThen(nestedMatchAction);
            }
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, asGroup.getGroupType(), nestedEnclosingFunction, nestedMatchAction, usedProperties);
        } else if (property.isLeaf() || property.isPrimitive() || optional && property.asOptional().getNestedProperty().isLeaf()) {
            ConsumeOneAndThen actualAction = !property.isParentPropertyName() ? new ConsumeOneAndThen(matchAction) : matchAction;
            matchActions.findOrAdd(currentPath).putRootValue(actualAction);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                matchActions.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(actualAction);
            }
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                if (primitiveProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(primitiveProperty.getDefaultValue());
                    }
                }
            } else if (property.isLeaf() && optional) {
                ConfigMappingInterface.LeafProperty leafProperty = property.asOptional().getNestedProperty().asLeaf();
                if (leafProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                    }
                }
            } else {
                ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
                if (leafProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                    }
                }
            }
        } else if (property.isMap()) {
            this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), getEnclosingFunction, namingStrategy, group);
        } else if (property.isCollection() || optional && property.asOptional().getNestedProperty().isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = optional ? property.asOptional().getNestedProperty().asCollection() : property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processLazyPropertyInGroup(currentPath, matchActions, defaultValues, getEnclosingFunction, matchAction, usedProperties, namingStrategy, group, false, collectionProperty.getElement());
        }
    }

    private void processLazyMapInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        GetOrCreateEnclosingMapInGroup getEnclosingMap = new GetOrCreateEnclosingMapInGroup(getEnclosingGroup, enclosingGroup, property);
        this.processLazyMap(currentPath, matchActions, defaultValues, property, getEnclosingMap, namingStrategy, enclosingGroup);
    }

    private void processLazyMap(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        ConfigMappingInterface.Property valueProperty = property.getValueProperty();
        Class<Converter<?>> keyConvertWith = property.hasKeyConvertWith() ? property.getKeyConvertWith() : null;
        Class<?> keyRawType = property.getKeyRawType();
        currentPath.addLast("*");
        if (valueProperty.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = valueProperty.asLeaf();
            Class<? extends Converter<?>> valConvertWith = leafProperty.getConvertWith();
            Class<?> valueRawType = leafProperty.getValueRawType();
            matchActions.findOrAdd(currentPath).putRootValue((mc, ni) -> {
                StringBuilder sb = mc.getStringBuilder();
                sb.setLength(0);
                sb.append(ni.getAllPreviousSegments());
                String configKey = sb.toString();
                Map map = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, (NameIterator)ni);
                String rawMapKey = ni.getPreviousSegment();
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Object key = keyConv.convert(rawMapKey);
                Converter valueConv = valConvertWith != null ? mc.getConverterInstance(valConvertWith) : config.requireConverter(valueRawType);
                map.put(key, config.getValue(configKey, valueConv));
            });
        } else if (valueProperty.isMap()) {
            this.processLazyMap(currentPath, matchActions, defaultValues, valueProperty.asMap(), (mc, ni) -> {
                ni.previous();
                Map enclosingMap = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, (NameIterator)ni);
                ni.next();
                String rawMapKey = ni.getPreviousSegment();
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Object key = keyConv.convert(rawMapKey);
                return (Map)enclosingMap.computeIfAbsent(key, x -> new HashMap());
            }, namingStrategy, enclosingGroup);
        } else {
            assert (valueProperty.isGroup());
            GetOrCreateEnclosingGroupInMap ef = new GetOrCreateEnclosingGroupInMap(getEnclosingMap, property, enclosingGroup, valueProperty.asGroup());
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, valueProperty.asGroup().getGroupType(), ef, ef, new HashSet<String>());
        }
        currentPath.removeLast();
    }

    private static boolean isCollection(ArrayDeque<String> currentPath) {
        return currentPath.getLast().endsWith("[*]");
    }

    private static ArrayDeque<String> inlineCollectionPath(ArrayDeque<String> currentPath) {
        ArrayDeque<String> inlineCollectionPath = new ArrayDeque<String>(currentPath);
        String last = inlineCollectionPath.removeLast();
        inlineCollectionPath.addLast(last.substring(0, last.length() - 3));
        return inlineCollectionPath;
    }

    static Map<?, ?> getOrCreateEnclosingMapInMap(ConfigMappingContext context, NameIterator ni, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.MapProperty property) {
        ni.previous();
        Map<?, ?> ourEnclosing = getEnclosingMap.apply(context, ni);
        String mapKey = ni.getNextSegment();
        Converter keyConverter = context.getKeyConverter(enclosingGroup.getInterfaceType(), property.getMethod().getName(), property.getLevels() - 1);
        Object realKey = keyConverter.convert(mapKey);
        HashMap map = (HashMap)ourEnclosing.get(realKey);
        if (map == null) {
            map = new HashMap();
            ourEnclosing.put(realKey, map);
        }
        ni.next();
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    KeyMap<String> getDefaultValues() {
        return this.defaultValues;
    }

    void mapConfiguration(SmallRyeConfig config) throws ConfigValidationException {
        for (ConfigSource configSource : config.getConfigSources()) {
            if (!(configSource instanceof DefaultValuesConfigSource)) continue;
            DefaultValuesConfigSource defaultValuesConfigSource = (DefaultValuesConfigSource)configSource;
            defaultValuesConfigSource.registerDefaults(this.getDefaultValues());
        }
        this.mapConfiguration(config, config.getConfigMappings());
    }

    private void mapConfiguration(SmallRyeConfig config, ConfigMappings mappings) throws ConfigValidationException {
        if (this.roots.isEmpty()) {
            return;
        }
        Assert.checkNotNullParam((String)"config", (Object)config);
        ConfigMappingContext context = new ConfigMappingContext(config);
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            String path = entry.getKey();
            List<Class<?>> roots = entry.getValue();
            for (Class<?> root : roots) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), path);
                ConfigMappingObject group = (ConfigMappingObject)context.constructRoot(root);
                context.registerRoot(root, path, group);
            }
        }
        HashSet<String> unknownProperties = new HashSet<String>();
        for (String name : config.getPropertyNames()) {
            NameIterator ni = new NameIterator(name);
            if (!this.isPropertyInRoot(ni)) continue;
            BiConsumer<ConfigMappingContext, NameIterator> action = this.matchActions.findRootValue(ni);
            if (action != null) {
                action.accept(context, ni);
                continue;
            }
            if (!ConfigMappingProvider.validateUnknown(this.validateUnknown, config)) continue;
            unknownProperties.add(name);
        }
        ConfigMappingProvider.unknownProperties(unknownProperties, context);
        ArrayList<ConfigValidationException.Problem> arrayList = context.getProblems();
        if (!arrayList.isEmpty()) {
            throw new ConfigValidationException(arrayList.toArray(ConfigValidationException.Problem.NO_PROBLEMS));
        }
        context.fillInOptionals();
        mappings.registerConfigMappings(context.getRootsMap());
    }

    private boolean isPropertyInRoot(NameIterator propertyName) {
        Set<String> registeredRoots = this.roots.keySet();
        block0: for (String registeredRoot : registeredRoots) {
            if (registeredRoot.length() == 0) {
                return true;
            }
            if (propertyName.getName().length() <= registeredRoot.length()) continue;
            NameIterator root = new NameIterator(registeredRoot);
            while (root.hasNext()) {
                String segment = root.getNextSegment();
                if (!propertyName.hasNext()) {
                    propertyName.goToStart();
                    continue block0;
                }
                String nextSegment = propertyName.getNextSegment();
                if (!segment.equals(ConfigMappingProvider.normalizeIfIndexed(nextSegment))) {
                    propertyName.goToStart();
                    continue block0;
                }
                root.next();
                propertyName.next();
                if (root.hasNext() || !propertyName.hasNext()) continue;
                propertyName.goToStart();
                return true;
            }
        }
        return false;
    }

    private static String normalizeIfIndexed(String propertyName) {
        int indexStart = propertyName.indexOf("[");
        int indexEnd = propertyName.indexOf("]");
        if (indexStart != -1 && indexEnd != -1) {
            return propertyName.substring(0, indexStart);
        }
        return propertyName;
    }

    private static boolean validateUnknown(boolean validateUnknown, SmallRyeConfig config) {
        return config.getOptionalValue("smallrye.config.mapping.validate-unknown", Boolean.class).orElse(validateUnknown);
    }

    private static void unknownProperties(Set<String> properties, ConfigMappingContext context) {
        HashSet<String> usedProperties = new HashSet<String>();
        for (String property : context.getConfig().getPropertyNames()) {
            if (properties.contains(property)) continue;
            usedProperties.add(StringUtil.replaceNonAlphanumericByUnderscores((String)property));
        }
        usedProperties.removeAll(properties);
        for (String property : properties) {
            boolean found = false;
            for (String usedProperty : usedProperties) {
                if (!usedProperty.equalsIgnoreCase(StringUtil.replaceNonAlphanumericByUnderscores((String)property))) continue;
                found = true;
                break;
            }
            if (found) continue;
            context.unknownConfigElement(property);
        }
    }

    static {
        KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> map = new KeyMap<BiConsumer<ConfigMappingContext, NameIterator>>();
        map.putRootValue(DO_NOTHING);
        IGNORE_EVERYTHING = map;
    }

    public static final class Builder {
        final Set<Class<?>> types = new HashSet();
        final Map<String, List<Class<?>>> roots = new HashMap();
        final List<String[]> ignored = new ArrayList<String[]>();
        boolean validateUnknown = true;

        Builder() {
        }

        public Builder addRoot(String path, Class<?> type) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            Assert.checkNotNullParam((String)"type", type);
            this.types.add(type);
            this.roots.computeIfAbsent(path, k -> new ArrayList(4)).add(ConfigMappingLoader.getConfigMappingClass(type));
            return this;
        }

        public Builder addIgnored(String path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.ignored.add(path.split("\\."));
            return this;
        }

        public Builder validateUnknown(boolean validateUnknown) {
            this.validateUnknown = validateUnknown;
            return this;
        }

        public ConfigMappingProvider build() {
            boolean allConfigurationProperties = true;
            for (Class<?> type : this.types) {
                if (ConfigMappingClass.getConfigurationClass(type) != null) continue;
                allConfigurationProperties = false;
                break;
            }
            if (allConfigurationProperties) {
                this.validateUnknown = false;
            }
            return new ConfigMappingProvider(this);
        }
    }

    static class GetFieldOfEnclosing
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction;
        private final Class<?> type;
        private final String memberName;

        GetFieldOfEnclosing(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName) {
            this.getEnclosingFunction = getEnclosingFunction;
            this.type = type;
            this.memberName = memberName;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext mc, NameIterator ni) {
            ConfigMappingObject outer = this.getEnclosingFunction.apply(mc, ni);
            return (ConfigMappingObject)mc.getEnclosedField(this.type, this.memberName, outer);
        }
    }

    static class GetOrCreateEnclosingMapInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup;
        final ConfigMappingInterface enclosingGroup;
        final ConfigMappingInterface.MapProperty property;

        GetOrCreateEnclosingMapInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.MapProperty property) {
            this.getEnclosingGroup = getEnclosingGroup;
            this.enclosingGroup = enclosingGroup;
            this.property = property;
        }

        @Override
        public Map<?, ?> apply(ConfigMappingContext context, NameIterator ni) {
            boolean consumeName;
            boolean bl = consumeName = !this.property.isParentPropertyName();
            if (consumeName) {
                ni.previous();
            }
            ConfigMappingObject ourEnclosing = this.getEnclosingGroup.apply(context, ni);
            if (consumeName) {
                ni.next();
            }
            Class<?> enclosingType = this.enclosingGroup.getInterfaceType();
            String methodName = this.property.getMethod().getName();
            context.applyNamingStrategy(this.enclosingGroup.getNamingStrategy());
            HashMap val = (HashMap)context.getEnclosedField(enclosingType, methodName, ourEnclosing);
            if (val == null) {
                val = new HashMap();
                context.registerEnclosedField(enclosingType, methodName, ourEnclosing, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }
    }

    static class GetOrCreateEnclosingGroupInMap
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        final BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap;
        final ConfigMappingInterface.MapProperty enclosingMap;
        final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;

        GetOrCreateEnclosingGroupInMap(BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.MapProperty enclosingMap, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup) {
            this.getEnclosingMap = getEnclosingMap;
            this.enclosingMap = enclosingMap;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            ni.previous();
            Map<?, ?> ourEnclosing = this.getEnclosingMap.apply(context, ni);
            ni.next();
            String mapKey = ni.getPreviousSegment();
            Converter keyConverter = context.getKeyConverter(this.enclosingGroup.getInterfaceType(), this.enclosingMap.getMethod().getName(), this.enclosingMap.getLevels() - 1);
            ConfigMappingObject val = (ConfigMappingObject)ourEnclosing.get(mapKey);
            context.applyNamingStrategy(this.enclosingGroup.getNamingStrategy());
            if (val == null) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), ni.getAllPreviousSegments());
                Object convertedKey = keyConverter.convert(mapKey);
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                ourEnclosing.put(convertedKey, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }
    }

    static class GetOrCreateEnclosingGroupInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;
        private final ArrayDeque<String> path;

        GetOrCreateEnclosingGroupInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup, ArrayDeque<String> path) {
            this.delegate = delegate;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
            this.path = new ArrayDeque<String>(path);
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            ConfigMappingObject ourEnclosing = this.delegate.apply(context, ni);
            Class<?> enclosingType = this.enclosingGroup.getInterfaceType();
            String key = GetOrCreateEnclosingGroupInGroup.indexName(this.enclosedGroup.getMethod().getName(), this.path, ni);
            ConfigMappingObject val = (ConfigMappingObject)context.getEnclosedField(enclosingType, key, ourEnclosing);
            context.applyNamingStrategy(this.enclosingGroup.getNamingStrategy());
            if (val == null) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), ni.getAllPreviousSegments());
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                context.registerEnclosedField(enclosingType, key, ourEnclosing, val);
            }
            return val;
        }

        private static String indexName(String name, ArrayDeque<String> groupPath, NameIterator nameIterator) {
            int i;
            String property = nameIterator.getAllPreviousSegments();
            int start = property.indexOf(ConfigMappingProvider.normalizeIfIndexed(groupPath.getLast()));
            if (start != -1 && (i = start + ConfigMappingProvider.normalizeIfIndexed(groupPath.getLast()).length()) < property.length() && property.charAt(i) == '[') {
                while (true) {
                    if (property.charAt(i) == ']') {
                        try {
                            int index = Integer.parseInt(property.substring(start + ConfigMappingProvider.normalizeIfIndexed(groupPath.getLast()).length() + 1, i));
                            return name + "[" + index + "]";
                        }
                        catch (NumberFormatException numberFormatException) {
                            break;
                        }
                    }
                    if (i >= property.length() - 1) break;
                    ++i;
                }
            }
            return name;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            this.apply(context, nameIterator);
        }
    }

    static class GetRootAction
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final Class<?> root;
        private final String rootPath;

        GetRootAction(Class<?> root, String rootPath) {
            this.root = root;
            this.rootPath = rootPath;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext mc, NameIterator ni) {
            return mc.getRoot(this.root, this.rootPath);
        }
    }

    static final class ConsumeOneAndThenFn<T>
    implements BiFunction<ConfigMappingContext, NameIterator, T> {
        private final BiFunction<ConfigMappingContext, NameIterator, T> delegate;

        ConsumeOneAndThenFn(BiFunction<ConfigMappingContext, NameIterator, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T apply(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            T result = this.delegate.apply(context, nameIterator);
            nameIterator.next();
            return result;
        }
    }

    static final class ConsumeOneAndThen
    implements BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiConsumer<ConfigMappingContext, NameIterator> delegate;

        ConsumeOneAndThen(BiConsumer<ConfigMappingContext, NameIterator> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            this.delegate.accept(context, nameIterator);
            nameIterator.next();
        }
    }
}

