/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.InjectionException;
import io.smallrye.beanbag.Injector;
import io.smallrye.beanbag.Scope;
import java.lang.reflect.Field;

final class FieldInjector<C, T>
implements Injector<C> {
    private final Field field;
    private final BeanSupplier<T> supplier;

    FieldInjector(Field field, BeanSupplier<T> supplier) {
        this.field = field;
        this.supplier = supplier;
    }

    @Override
    public void injectInto(Scope scope, C instance) {
        T value;
        try {
            value = this.supplier.get(scope);
        }
        catch (Throwable t) {
            throw new InjectionException("Failed to acquire value from provider for field " + this.field.getDeclaringClass().getSimpleName() + "#" + this.field.getName() + " of object " + instance, t);
        }
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new InjectionException("Failed to inject value " + value + " into field " + this.field.getDeclaringClass().getSimpleName() + "#" + this.field.getName() + " of object " + instance, e);
        }
    }
}

