/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.Futures;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.MultiResultNode;
import io.quarkus.qute.ParameterDeclarationNode;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.TextNode;
import io.quarkus.qute.TraceManagerImpl;
import io.quarkus.qute.trace.ResolveEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Results {
    public static final CompletedStage<Object> FALSE = CompletedStage.of(false);
    public static final CompletedStage<Object> TRUE = CompletedStage.of(true);
    public static final CompletedStage<Object> NULL = CompletedStage.NULL;

    private Results() {
    }

    public static boolean isNotFound(Object result) {
        return result instanceof NotFound;
    }

    public static CompletionStage<Object> notFound(EvalContext evalContext) {
        return CompletedStage.of(NotFound.from(evalContext));
    }

    public static CompletionStage<Object> notFound(String name) {
        return CompletedStage.of(NotFound.from(name));
    }

    public static CompletionStage<Object> notFound() {
        return CompletedStage.of(NotFound.EMPTY);
    }

    static CompletionStage<ResultNode> resolveAndProcess(List<TemplateNode> nodes, ResolutionContext context, EngineImpl engine) {
        int nodesCount = nodes.size();
        if (nodesCount == 1) {
            return Results.resolveWith(nodes.get(0), context, engine);
        }
        Supplier[] allResults = new Supplier[nodesCount];
        ArrayList<CompletableFuture<ResultNode>> asyncResults = null;
        int idx = 0;
        for (TemplateNode templateNode : nodes) {
            CompletionStage<ResultNode> result = Results.resolveWith(templateNode, context, engine);
            if (result instanceof CompletedStage) {
                allResults[idx++] = (CompletedStage)result;
                continue;
            }
            CompletableFuture<ResultNode> fu = result.toCompletableFuture();
            if (asyncResults == null) {
                asyncResults = new ArrayList<CompletableFuture<ResultNode>>();
            }
            asyncResults.add(fu);
            allResults[idx++] = Futures.toSupplier(fu);
        }
        return Results.toCompletionStage(allResults, asyncResults);
    }

    private static CompletionStage<ResultNode> toCompletionStage(Supplier<ResultNode>[] allResults, List<CompletableFuture<ResultNode>> asyncResults) {
        if (asyncResults == null) {
            return CompletedStage.of(new MultiResultNode(allResults));
        }
        CompletableFuture<ResultNode> ret = new CompletableFuture<ResultNode>();
        CompletableFuture<Void> cs = asyncResults.size() == 1 ? (CompletableFuture<Void>)asyncResults.get(0) : CompletableFuture.allOf(asyncResults.toArray(new CompletableFuture[0]));
        cs.whenComplete((v, t) -> {
            if (t != null) {
                ret.completeExceptionally((Throwable)t);
            } else {
                ret.complete(new MultiResultNode(allResults));
            }
        });
        return ret;
    }

    private static CompletionStage<ResultNode> resolveWith(TemplateNode templateNode, ResolutionContext context, EngineImpl engine) {
        TraceManagerImpl traceManager = engine.traceManager;
        if (traceManager == null) {
            return Results.doResolveWith(templateNode, context);
        }
        ResolveEvent event = new ResolveEvent(templateNode, context, engine);
        traceManager.fireBeforeResolveEvent(event);
        return Results.doResolveWith(templateNode, context).whenComplete((result, error) -> {
            event.resolve((ResultNode)result, (Throwable)error);
            traceManager.fireAfterResolveEvent(event);
        });
    }

    private static CompletionStage<ResultNode> doResolveWith(TemplateNode templateNode, ResolutionContext context) {
        if (templateNode instanceof TextNode) {
            TextNode textNode = (TextNode)templateNode;
            return textNode.resolve(context);
        }
        if (templateNode instanceof ExpressionNode) {
            ExpressionNode expressionNode = (ExpressionNode)templateNode;
            return expressionNode.resolve(context);
        }
        if (templateNode instanceof SectionNode) {
            SectionNode sectionNode = (SectionNode)templateNode;
            return sectionNode.resolve(context);
        }
        if (templateNode instanceof ParameterDeclarationNode) {
            ParameterDeclarationNode paramNode = (ParameterDeclarationNode)templateNode;
            return paramNode.resolve(context);
        }
        return templateNode.resolve(context);
    }

    static CompletionStage<ResultNode> process(List<CompletionStage<ResultNode>> results) {
        Supplier[] allResults = new Supplier[results.size()];
        ArrayList<CompletableFuture<ResultNode>> asyncResults = null;
        int idx = 0;
        for (CompletionStage<ResultNode> result : results) {
            if (result instanceof CompletedStage) {
                allResults[idx++] = (CompletedStage)result;
                continue;
            }
            CompletableFuture<ResultNode> fu = result.toCompletableFuture();
            if (asyncResults == null) {
                asyncResults = new ArrayList<CompletableFuture<ResultNode>>();
            }
            asyncResults.add(fu);
            allResults[idx++] = Futures.toSupplier(fu);
        }
        return Results.toCompletionStage(allResults, asyncResults);
    }

    public static final class NotFound {
        public static final NotFound EMPTY = new NotFound(null, null);
        private final Optional<String> name;
        private final EvalContext evalContext;

        public static NotFound from(EvalContext context) {
            return new NotFound(Objects.requireNonNull(context), null);
        }

        public static NotFound from(String name) {
            return new NotFound(null, Objects.requireNonNull(name));
        }

        private NotFound(EvalContext evalContext, String name) {
            this.name = Optional.ofNullable(name);
            this.evalContext = evalContext;
        }

        public Optional<Object> getBase() {
            return this.evalContext != null ? Optional.ofNullable(this.evalContext.getBase()) : Optional.empty();
        }

        public Optional<String> getName() {
            return this.evalContext != null ? Optional.of(this.evalContext.getName()) : this.name;
        }

        public List<Expression> getParams() {
            return this.evalContext != null ? this.evalContext.getParams() : Collections.emptyList();
        }

        public String asMessage() {
            String name = this.getName().orElse(null);
            if (name != null) {
                Object base = this.getBase().orElse(null);
                List<Expression> params = this.getParams();
                StringBuilder builder = new StringBuilder();
                if (base instanceof Map || base instanceof Mapper) {
                    builder.append("Key ").append("\"").append(name).append("\" not found in the");
                    if (this.isDataMap(base)) {
                        builder.append(" template data map with keys ");
                        if (base instanceof Map) {
                            builder.append(((Map)base).keySet().stream().filter(Predicate.not("io.quarkus.qute.dataMap"::equals)).collect(Collectors.toList()));
                        } else if (base instanceof Mapper) {
                            builder.append(((Mapper)base).mappedKeys().stream().filter(Predicate.not("io.quarkus.qute.dataMap"::equals)).collect(Collectors.toList()));
                        }
                    } else {
                        builder.append(" map with keys ");
                        if (base instanceof Map) {
                            builder.append(((Map)base).keySet());
                        } else if (base instanceof Mapper) {
                            builder.append(((Mapper)base).mappedKeys());
                        }
                    }
                } else if (!params.isEmpty()) {
                    builder.append("Method ").append("\"").append(name).append("(").append(params.stream().map(Expression::toOriginalString).collect(Collectors.joining(","))).append(")").append("\" not found").append(" on the base object \"").append(base == null ? "null" : base.getClass().getName()).append("\"");
                } else {
                    builder.append("Property ").append("\"").append(name).append("\" not found").append(" on the base object \"").append(base == null ? "null" : base.getClass().getName()).append("\"");
                }
                return builder.toString();
            }
            return "NOT_FOUND";
        }

        private boolean isDataMap(Object base) {
            if (base instanceof Map) {
                return ((Map)base).containsKey("io.quarkus.qute.dataMap");
            }
            if (base instanceof Mapper) {
                return ((Mapper)base).get("io.quarkus.qute.dataMap") != null;
            }
            return false;
        }

        public String toString() {
            return "NOT_FOUND";
        }
    }
}

