/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.quarkus.dev.console.DevConsoleRequest;
import io.quarkus.dev.console.DevConsoleResponse;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import io.quarkus.netty.runtime.virtual.VirtualResponseHandler;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import java.io.ByteArrayOutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class DevConsoleHttpHandler
implements Consumer<DevConsoleRequest> {
    private static final Logger log = Logger.getLogger(DevConsoleHttpHandler.class);
    public static VirtualAddress QUARKUS_DEV_CONSOLE = new VirtualAddress("quarkus-dev-console");
    private static final int BUFFER_SIZE = 8096;

    @Override
    public void accept(DevConsoleRequest request) {
        try {
            this.nettyDispatch(request);
        }
        catch (Exception e) {
            request.getResponse().completeExceptionally(e);
        }
    }

    private void nettyDispatch(DevConsoleRequest request) throws Exception {
        String path = request.getPath();
        QuarkusHttpHeaders quarkusHeaders = new QuarkusHttpHeaders();
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.getMethod()), path, (HttpHeaders)quarkusHeaders);
        for (Map.Entry i : request.getHeaders().entrySet()) {
            nettyRequest.headers().add((String)i.getKey(), (Iterable)i.getValue());
        }
        if (!nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        }
        LastHttpContent requestContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (request.getBody() != null) {
            ByteBuf body = Unpooled.wrappedBuffer((byte[])request.getBody());
            requestContent = new DefaultLastHttpContent(body);
        }
        NettyResponseHandler handler = new NettyResponseHandler(request);
        VirtualClientConnection connection = VirtualClientConnection.connect((VirtualResponseHandler)handler, (VirtualAddress)QUARKUS_DEV_CONSOLE, null);
        connection.sendMessage((Object)nettyRequest);
        connection.sendMessage((Object)requestContent);
    }

    private ByteArrayOutputStream createByteStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8096);
        return baos;
    }

    private class NettyResponseHandler
    implements VirtualResponseHandler {
        ByteArrayOutputStream baos;
        WritableByteChannel byteChannel;
        final DevConsoleRequest request;
        final DevConsoleResponse responseBuilder = new DevConsoleResponse();

        public NettyResponseHandler(DevConsoleRequest request) {
            this.request = request;
        }

        public CompletableFuture<DevConsoleResponse> getFuture() {
            return this.request.getResponse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Object msg) {
            try {
                FileRegion file;
                if (msg instanceof HttpResponse) {
                    HttpResponse res = (HttpResponse)msg;
                    this.responseBuilder.setStatus(res.status().code());
                    for (String name : res.headers().names()) {
                        this.responseBuilder.getHeaders().put(name, res.headers().getAll(name));
                    }
                }
                if (msg instanceof HttpContent) {
                    HttpContent content = (HttpContent)msg;
                    int readable = content.content().readableBytes();
                    if (this.baos == null && readable > 0) {
                        this.baos = DevConsoleHttpHandler.this.createByteStream();
                    }
                    for (int i = 0; i < readable; ++i) {
                        this.baos.write(content.content().readByte());
                    }
                }
                if (msg instanceof FileRegion && (file = (FileRegion)msg).count() > 0L && file.transferred() < file.count()) {
                    if (this.baos == null) {
                        this.baos = DevConsoleHttpHandler.this.createByteStream();
                    }
                    if (this.byteChannel == null) {
                        this.byteChannel = Channels.newChannel(this.baos);
                    }
                    file.transferTo(this.byteChannel, file.transferred());
                }
                if (msg instanceof LastHttpContent) {
                    if (this.baos != null) {
                        this.responseBuilder.setBody(this.baos.toByteArray());
                    }
                    this.getFuture().complete(this.responseBuilder);
                }
            }
            catch (Throwable ex) {
                this.getFuture().completeExceptionally(ex);
            }
            finally {
                if (msg != null) {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }

        public void close() {
            if (!this.getFuture().isDone()) {
                this.getFuture().completeExceptionally(new RuntimeException("Connection closed"));
            }
        }
    }
}

