/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.filter;

import java.util.HashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.logging.Logger;

public abstract class AutoSecurityFilter
implements OASFilter {
    private static final Logger log = Logger.getLogger(AutoSecurityFilter.class);
    private String securitySchemeName;
    private String securitySchemeDescription;

    public AutoSecurityFilter() {
    }

    public AutoSecurityFilter(String securitySchemeName, String securitySchemeDescription) {
        this.securitySchemeName = securitySchemeName;
        this.securitySchemeDescription = securitySchemeDescription;
    }

    public String getSecuritySchemeName() {
        return this.securitySchemeName;
    }

    public void setSecuritySchemeName(String securitySchemeName) {
        this.securitySchemeName = securitySchemeName;
    }

    public String getSecuritySchemeDescription() {
        return this.securitySchemeDescription;
    }

    public void setSecuritySchemeDescription(String securitySchemeDescription) {
        this.securitySchemeDescription = securitySchemeDescription;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(OASFactory.createComponents());
        }
        HashMap<String, SecurityScheme> securitySchemes = new HashMap<String, SecurityScheme>();
        if (openAPI.getComponents().getSecuritySchemes() != null && !openAPI.getComponents().getSecuritySchemes().isEmpty()) {
            securitySchemes.putAll(openAPI.getComponents().getSecuritySchemes());
        }
        SecurityScheme securityScheme = this.getSecurityScheme();
        securityScheme.setDescription(this.securitySchemeDescription);
        securitySchemes.put(this.securitySchemeName, securityScheme);
        openAPI.getComponents().setSecuritySchemes(securitySchemes);
    }

    protected abstract SecurityScheme getSecurityScheme();

    protected String getUrl(String configKey, String defaultValue, String shouldEndWith) {
        Config c = ConfigProvider.getConfig();
        Object u = c.getOptionalValue(configKey, String.class).orElse(defaultValue);
        if (u != null && !((String)u).endsWith(shouldEndWith)) {
            u = (String)u + shouldEndWith;
        }
        return u;
    }
}

