/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class SecuredInterfaceAnnotationBuildItem
extends MultiBuildItem {
    private final DotName annotationName;
    private final SecuredAnnotationTargetKind targetKind;

    private SecuredInterfaceAnnotationBuildItem(DotName annotationName, SecuredAnnotationTargetKind targetKind) {
        this.annotationName = Objects.requireNonNull(annotationName);
        this.targetKind = targetKind;
    }

    public Predicate<ClassInfo> getIsInterfaceWithTransformations() {
        return switch (this.targetKind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> ci -> ci.isInterface() && ci.hasDeclaredAnnotation(this.annotationName);
            case 0 -> ci -> ci.isInterface() && ci.hasAnnotation(this.annotationName);
        };
    }

    public DotName getAnnotationName() {
        return this.annotationName;
    }

    public static SecuredInterfaceAnnotationBuildItem ofClassAnnotation(String annotationName) {
        return new SecuredInterfaceAnnotationBuildItem(DotName.createSimple((String)annotationName), SecuredAnnotationTargetKind.CLASS);
    }

    public static SecuredInterfaceAnnotationBuildItem ofMethodAnnotation(Class<?> annotation) {
        return new SecuredInterfaceAnnotationBuildItem(DotName.createSimple(annotation), SecuredAnnotationTargetKind.METHOD);
    }

    private static enum SecuredAnnotationTargetKind {
        METHOD,
        CLASS;

    }
}

