/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi;

import io.quarkus.security.Authenticated;
import io.quarkus.security.PermissionsAllowed;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

@Deprecated(since="3.30", forRemoval=true)
public final class SecurityTransformerUtils {
    public static final DotName DENY_ALL = DotName.createSimple((String)DenyAll.class.getName());
    private static final Set<DotName> SECURITY_ANNOTATIONS = Set.of(DotName.createSimple((String)RolesAllowed.class.getName()), DotName.createSimple((String)PermissionsAllowed.class.getName()), DotName.createSimple((String)PermissionsAllowed.List.class.getName()), DotName.createSimple((String)Authenticated.class.getName()), DotName.createSimple((String)DenyAll.class.getName()), DotName.createSimple((String)PermitAll.class.getName()));

    private SecurityTransformerUtils() {
    }

    public static boolean hasSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(methodInfo).isPresent();
    }

    public static boolean hasSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(classInfo).isPresent();
    }

    public static boolean hasSecurityAnnotation(Collection<AnnotationInstance> instances) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(instances).isPresent();
    }

    public static boolean isStandardSecurityAnnotation(AnnotationInstance annotationInstance) {
        return SECURITY_ANNOTATIONS.contains(annotationInstance.name());
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(methodInfo.annotations());
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(classInfo.declaredAnnotations());
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(Collection<AnnotationInstance> instances) {
        for (AnnotationInstance instance : instances) {
            if (!SECURITY_ANNOTATIONS.contains(instance.name())) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }
}

