/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.resteasy.runtime.standalone.BufferAllocator;
import io.quarkus.resteasy.runtime.standalone.LazyHostSupplier;
import io.quarkus.resteasy.runtime.standalone.QuarkusResteasySecurityContext;
import io.quarkus.resteasy.runtime.standalone.RequestDispatcher;
import io.quarkus.resteasy.runtime.standalone.VertxBlockingOutput;
import io.quarkus.resteasy.runtime.standalone.VertxHttpRequest;
import io.quarkus.resteasy.runtime.standalone.VertxHttpResponse;
import io.quarkus.resteasy.runtime.standalone.VertxOutput;
import io.quarkus.resteasy.runtime.standalone.VertxUtil;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.VertxInputStream;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.core.SecurityContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class VertxRequestHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.resteasy");
    protected final Vertx vertx;
    protected final RequestDispatcher dispatcher;
    protected final String rootPath;
    protected final BufferAllocator allocator;
    protected final BeanContainer beanContainer;
    protected final CurrentIdentityAssociation association;
    protected final CurrentVertxRequest currentVertxRequest;
    protected final Executor executor;
    protected final long readTimeout;

    public VertxRequestHandler(Vertx vertx, BeanContainer beanContainer, ResteasyDeployment deployment, String rootPath, BufferAllocator allocator, Executor executor, long readTimeout) {
        this.vertx = vertx;
        this.beanContainer = beanContainer;
        this.dispatcher = new RequestDispatcher((SynchronousDispatcher)deployment.getDispatcher(), deployment.getProviderFactory(), null, Thread.currentThread().getContextClassLoader());
        this.rootPath = rootPath;
        this.allocator = allocator;
        this.executor = executor;
        this.readTimeout = readTimeout;
        Instance association = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = association.isResolvable() ? (CurrentIdentityAssociation)association.get() : null;
        this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
    }

    public void handle(final RoutingContext request) {
        ByteArrayInputStream is;
        try {
            is = request.getBody() != null ? new ByteArrayInputStream(request.getBody().getBytes()) : new VertxInputStream(request, this.readTimeout);
        }
        catch (IOException e) {
            request.fail((Throwable)e);
            return;
        }
        if (BlockingOperationControl.isBlockingAllowed()) {
            try {
                this.dispatch(request, is, new VertxBlockingOutput(request.request()));
            }
            catch (Throwable e) {
                request.fail(e);
            }
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        VertxRequestHandler.this.dispatch(request, is, new VertxBlockingOutput(request.request()));
                    }
                    catch (Throwable e) {
                        request.fail(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(RoutingContext routingContext, InputStream is, VertxOutput output) {
        block20: {
            ManagedContext requestContext = this.beanContainer.requestContext();
            requestContext.activate();
            routingContext.remove("io.quarkus.vertx.http.auth-failure-handler");
            QuarkusHttpUser user = (QuarkusHttpUser)routingContext.user();
            if (this.association != null) {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)routingContext, null));
            }
            this.currentVertxRequest.setCurrent(routingContext);
            try {
                Context ctx = this.vertx.getOrCreateContext();
                HttpServerRequest request = routingContext.request();
                ResteasyUriInfo uriInfo = VertxUtil.extractUriInfo(request, this.rootPath);
                ResteasyHttpHeaders headers = VertxUtil.extractHttpHeaders(request);
                HttpServerResponse response = request.response();
                VertxHttpResponse vertxResponse = new VertxHttpResponse(request, this.dispatcher.getProviderFactory(), request.method(), this.allocator, output, routingContext);
                LazyHostSupplier hostSupplier = new LazyHostSupplier(request);
                VertxHttpRequest vertxRequest = new VertxHttpRequest(ctx, routingContext, headers, uriInfo, request.rawMethod(), hostSupplier, this.dispatcher.getDispatcher(), vertxResponse, requestContext);
                vertxRequest.setInputStream(is);
                try {
                    ResteasyContext.pushContext(SecurityContext.class, (Object)new QuarkusResteasySecurityContext(request, routingContext));
                    ResteasyContext.pushContext(RoutingContext.class, (Object)routingContext);
                    this.dispatcher.service(ctx, request, response, (HttpRequest)vertxRequest, vertxResponse, true);
                }
                catch (Failure e1) {
                    vertxResponse.setStatus(e1.getErrorCode());
                    if (e1.isLoggable()) {
                        log.error((Object)e1);
                    }
                }
                catch (Throwable ex) {
                    routingContext.fail(ex);
                }
                boolean suspended = vertxRequest.getAsyncContext().isSuspended();
                boolean requestContextActive = requestContext.isActive();
                if (!suspended) {
                    try {
                        if (requestContextActive) {
                            requestContext.terminate();
                        }
                        break block20;
                    }
                    finally {
                        try {
                            vertxResponse.finish();
                        }
                        catch (IOException e) {
                            log.debug((Object)"IOException writing JAX-RS response", (Throwable)e);
                        }
                    }
                }
                requestContext.deactivate();
            }
            catch (Throwable t) {
                try {
                    routingContext.fail(t);
                }
                finally {
                    if (requestContext.isActive()) {
                        requestContext.terminate();
                    }
                }
            }
        }
    }
}

