/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.BackChannelLogoutHandler;
import io.quarkus.oidc.runtime.OidcImpl;
import io.quarkus.oidc.runtime.ResourceMetadataHandler;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TenantConfigContextImpl;
import io.quarkus.oidc.runtime.TenantContextFactory;
import io.quarkus.proxy.ProxyConfigurationRegistry;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.spi.CreationalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jboss.logging.Logger;

public final class TenantConfigBean {
    private static final Logger LOG = Logger.getLogger(TenantConfigBean.class);
    private final Map<String, TenantConfigContext> staticTenantsConfig;
    private final Map<String, TenantConfigContext> dynamicTenantsConfig;
    private final TenantConfigContext defaultTenant;
    private final TenantContextFactory tenantContextFactory;

    TenantConfigBean(Vertx vertx, TlsConfigurationRegistry tlsConfigurationRegistry, OidcImpl oidc, boolean securityEventsEnabled, ProxyConfigurationRegistry proxyConfigurationRegistry) {
        this.tenantContextFactory = new TenantContextFactory(vertx, tlsConfigurationRegistry, securityEventsEnabled, proxyConfigurationRegistry);
        this.dynamicTenantsConfig = new ConcurrentHashMap<String, TenantConfigContext>();
        this.staticTenantsConfig = this.tenantContextFactory.createStaticTenantConfigs(oidc.getStaticTenantConfigs(), oidc.getDefaultTenantConfig());
        this.defaultTenant = this.tenantContextFactory.createDefaultTenantConfig(oidc.getStaticTenantConfigs(), oidc.getDefaultTenantConfig());
    }

    Uni<TenantConfigContext> createDynamicTenantContext(final OidcTenantConfig oidcConfig) {
        final String tenantId = oidcConfig.tenantId().orElseThrow();
        TenantConfigContext tenant = this.dynamicTenantsConfig.get(tenantId);
        if (tenant != null) {
            return Uni.createFrom().item((Object)tenant);
        }
        return this.tenantContextFactory.createDynamic(oidcConfig).onItem().transform((Function)new Function<TenantConfigContext, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(TenantConfigContext t) {
                TenantConfigContext previousValue = TenantConfigBean.this.dynamicTenantsConfig.putIfAbsent(tenantId, t);
                if (previousValue == null) {
                    BackChannelLogoutHandler.fireBackChannelLogoutReadyEvent(oidcConfig);
                    ResourceMetadataHandler.fireResourceMetadataReadyEvent(oidcConfig);
                }
                return t;
            }
        });
    }

    Uni<TenantConfigContext> updateDynamicTenantContext(OidcTenantConfig oidcConfig) {
        String tenantId = oidcConfig.tenantId().orElseThrow();
        TenantConfigContext tenant = this.dynamicTenantsConfig.get(tenantId);
        if (tenant != null) {
            LOG.debugf("Updating the resolved tenant %s configuration with a new configuration", (Object)tenantId);
            TenantConfigContextImpl newTenant = new TenantConfigContextImpl(tenant, oidcConfig);
            this.dynamicTenantsConfig.put(tenantId, newTenant);
            BackChannelLogoutHandler.fireBackChannelLogoutChangedEvent(oidcConfig, tenant);
            ResourceMetadataHandler.fireResourceMetadataChangedEvent(oidcConfig, tenant);
            return Uni.createFrom().item((Object)newTenant);
        }
        return this.createDynamicTenantContext(oidcConfig);
    }

    Uni<TenantConfigContext> replaceDynamicTenantContext(OidcTenantConfig oidcConfig) {
        String tenantId = oidcConfig.tenantId().orElseThrow();
        LOG.debugf("Replacing the resolved tenant %s configuration with a new configuration", (Object)tenantId);
        this.dynamicTenantsConfig.remove(tenantId);
        return this.createDynamicTenantContext(oidcConfig);
    }

    public Map<String, TenantConfigContext> getStaticTenantsConfig() {
        return this.staticTenantsConfig;
    }

    List<TenantConfigContext> getAllTenantConfigs() {
        ArrayList<TenantConfigContext> result = new ArrayList<TenantConfigContext>();
        result.add(this.getDefaultTenant());
        result.addAll(this.getStaticTenantsConfig().values());
        result.addAll(this.dynamicTenantsConfig.values());
        return result;
    }

    public TenantConfigContext getStaticTenant(String tenantId) {
        return this.staticTenantsConfig.get(tenantId);
    }

    public TenantConfigContext getDefaultTenant() {
        return this.defaultTenant;
    }

    public TenantConfigContext getDynamicTenant(String tenantId) {
        return this.dynamicTenantsConfig.get(tenantId);
    }

    public static class Destroyer
    implements BeanDestroyer<TenantConfigBean> {
        public void destroy(TenantConfigBean instance, CreationalContext<TenantConfigBean> creationalContext, Map<String, Object> params) {
            if (instance.defaultTenant != null && instance.defaultTenant.provider() != null) {
                instance.defaultTenant.provider().close();
            }
            for (TenantConfigContext i : instance.staticTenantsConfig.values()) {
                if (i.provider() == null) continue;
                i.provider().close();
            }
            for (TenantConfigContext i : instance.dynamicTenantsConfig.values()) {
                if (i.provider() == null) continue;
                i.provider().close();
            }
        }
    }
}

