/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultNativeImageLauncher;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.TestConfigUtil;
import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.launcher.DefaultInitContextBase;
import io.smallrye.config.SmallRyeConfig;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.ConfigProvider;

public class NativeImageLauncherProvider
implements ArtifactLauncherProvider {
    @Override
    public boolean supportsArtifactType(String type, String testProfile) {
        return ArtifactTypeUtil.isNativeBinary(type);
    }

    public NativeImageLauncher create(ArtifactLauncherProvider.CreateContext context) {
        String pathStr = context.quarkusArtifactProperties().getProperty("path");
        if (pathStr != null && !pathStr.isEmpty()) {
            ServiceLoader<NativeImageLauncher> loader = ServiceLoader.load(NativeImageLauncher.class);
            Iterator<NativeImageLauncher> iterator = loader.iterator();
            Object launcher = iterator.hasNext() ? iterator.next() : new DefaultNativeImageLauncher();
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
            TestConfig testConfig = (TestConfig)config.getConfigMapping(TestConfig.class);
            launcher.init((ArtifactLauncher.InitContext)new DefaultNativeImageInitContext(((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), testConfig.waitTime(), testConfig.nativeImageProfile(), TestConfigUtil.argLineValues((String)testConfig.argLine().orElse("")), testConfig.env(), context.devServicesLaunchResult(), System.getProperty("native.image.path"), config.getOptionalValue("quarkus.package.output-directory", String.class).orElse(null), context.testClass()));
            return launcher;
        }
        throw new IllegalStateException("The path of the native binary could not be determined");
    }

    public static class DefaultNativeImageInitContext
    extends DefaultInitContextBase
    implements NativeImageLauncher.NativeImageInitContext {
        private final String nativeImagePath;
        private final Class<?> testClass;
        private final String configuredOutputDirectory;

        public DefaultNativeImageInitContext(int httpPort, int httpsPort, Duration waitTime, String testProfile, List<String> argLine, Map<String, String> env, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult, String nativeImagePath, String configuredOutputDirectory, Class<?> testClass) {
            super(httpPort, httpsPort, waitTime, testProfile, argLine, env, devServicesLaunchResult);
            this.nativeImagePath = nativeImagePath;
            this.configuredOutputDirectory = configuredOutputDirectory;
            this.testClass = testClass;
        }

        public String nativeImagePath() {
            return this.nativeImagePath;
        }

        public String getConfiguredOutputDirectory() {
            return this.configuredOutputDirectory;
        }

        public Class<?> testClass() {
            return this.testClass;
        }
    }
}

