/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.model.gradle.QuarkusModel;
import io.quarkus.bootstrap.util.PathsUtils;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.IntegrationTestExtensionState;
import io.quarkus.test.junit.NativeDevServicesHandler;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;

final class IntegrationTestUtil {
    private IntegrationTestUtil() {
    }

    static void ensureNoInjectAnnotationIsUsed(Class<?> testClass) {
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation == null) continue;
                throw new JUnitException("@Inject is not supported in @NativeImageTest and @QuarkusIntegrationTest tests. Offending field is " + field.getDeclaringClass().getTypeName() + "." + field.getName());
            }
            current = current.getSuperclass();
        }
    }

    static Class<? extends QuarkusTestProfile> findProfile(Class<?> testClass) {
        while (testClass != Object.class) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation != null) {
                return annotation.value();
            }
            testClass = testClass.getSuperclass();
        }
        return null;
    }

    static void doProcessTestInstance(Object testInstance, ExtensionContext context) {
        TestHTTPResourceManager.inject((Object)testInstance);
        ExtensionContext root = context.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        IntegrationTestExtensionState state = (IntegrationTestExtensionState)store.get((Object)IntegrationTestExtensionState.class.getName(), IntegrationTestExtensionState.class);
        state.getTestResourceManager().inject(testInstance);
    }

    static Map<String, String> getSysPropsToRestore() {
        HashMap<String, String> sysPropRestore = new HashMap<String, String>();
        sysPropRestore.put("quarkus.test.profile", System.getProperty("quarkus.test.profile"));
        return sysPropRestore;
    }

    static TestProfileAndProperties determineTestProfileAndProperties(Class<? extends QuarkusTestProfile> profile, Map<String, String> sysPropRestore) throws InstantiationException, IllegalAccessException {
        HashMap<String, String> properties = new HashMap<String, String>();
        QuarkusTestProfile testProfile = null;
        if (profile != null) {
            String configProfile;
            testProfile = profile.newInstance();
            properties.putAll(testProfile.getConfigOverrides());
            Set<Class<?>> enabledAlternatives = testProfile.getEnabledAlternatives();
            if (!enabledAlternatives.isEmpty()) {
                properties.put("quarkus.arc.selected-alternatives", enabledAlternatives.stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if ((configProfile = testProfile.getConfigProfile()) != null) {
                properties.put("quarkus.profile", configProfile);
            }
            properties.put("quarkus.configuration.build-time-mismatch-at-runtime", "fail");
            for (Map.Entry i : properties.entrySet()) {
                sysPropRestore.put((String)i.getKey(), System.getProperty((String)i.getKey()));
            }
            for (Map.Entry i : properties.entrySet()) {
                System.setProperty((String)i.getKey(), (String)i.getValue());
            }
        }
        return new TestProfileAndProperties(testProfile, properties);
    }

    static void startLauncher(ArtifactLauncher launcher, Map<String, String> additionalProperties, Runnable sslSetter) throws IOException {
        launcher.addSystemProperties(additionalProperties);
        try {
            launcher.start();
        }
        catch (IOException e) {
            try {
                launcher.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        if (launcher.listensOnSsl() && sslSetter != null) {
            sslSetter.run();
        }
    }

    static Map<String, String> handleDevDb(ExtensionContext context) throws Exception {
        Path outputDir;
        Class requiredTestClass = context.getRequiredTestClass();
        Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass);
        Path appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((String)testClassLocation.toString());
        PathsCollection.Builder rootBuilder = PathsCollection.builder();
        if (!appClassLocation.equals(testClassLocation)) {
            rootBuilder.add(testClassLocation);
            Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
            if (testResourcesLocation != null) {
                rootBuilder.add(testResourcesLocation);
            }
        }
        QuarkusBootstrap.Builder runnerBuilder = QuarkusBootstrap.builder().setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST);
        Object profileInstance = null;
        Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
        runnerBuilder.setProjectRoot(projectRoot);
        try {
            outputDir = projectRoot.resolve(projectRoot.relativize(testClassLocation).getName(0));
        }
        catch (Exception e) {
            outputDir = projectRoot;
        }
        runnerBuilder.setTargetDirectory(outputDir);
        rootBuilder.add(appClassLocation);
        Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
        if (appResourcesLocation != null) {
            rootBuilder.add(appResourcesLocation);
        }
        if (System.getProperty("quarkus-internal-test.serialized-app-model.path") == null) {
            QuarkusModel model = BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot);
            if (model != null) {
                PathsCollection classDirectories = PathsUtils.toPathsCollection((Collection)model.getWorkspace().getMainModule().getSourceSet().getSourceDirectories());
                for (Path classes : classDirectories) {
                    if (!Files.exists(classes, new LinkOption[0]) || rootBuilder.contains(classes)) continue;
                    rootBuilder.add(classes);
                }
            }
        } else if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
            PathsCollection sourceDirectories;
            for (PathsCollection sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                Path directory = Paths.get((String)sourceDirectory, new String[0]);
                if (!Files.exists(directory, new LinkOption[0]) || rootBuilder.contains(directory)) continue;
                rootBuilder.add(directory);
            }
        }
        runnerBuilder.setApplicationRoot(rootBuilder.build());
        CuratedApplication curatedApplication = runnerBuilder.setTest(true).build().bootstrap();
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Class)requiredTestClass);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Class)requiredTestClass);
        final HashMap<String, String> propertyMap = new HashMap<String, String>();
        curatedApplication.createAugmentor().performCustomBuild(NativeDevServicesHandler.class.getName(), (Object)new BiConsumer<String, String>(){

            @Override
            public void accept(String s, String s2) {
                propertyMap.put(s, s2);
            }
        }, new String[]{DevServicesNativeConfigResultBuildItem.class.getName()});
        return propertyMap;
    }

    static Properties readQuarkusArtifactProperties(ExtensionContext context) {
        Path buildOutputDirectory = IntegrationTestUtil.determineBuildOutputDirectory(context);
        Path artifactProperties = buildOutputDirectory.resolve("quarkus-artifact.properties");
        if (!Files.exists(artifactProperties, new LinkOption[0])) {
            TestLauncher testLauncher = IntegrationTestUtil.determineTestLauncher();
            Object errorMessage = "Unable to locate the artifact metadata file created that must be created by Quarkus in order to run integration tests. ";
            if (testLauncher == TestLauncher.MAVEN) {
                String testClassName;
                errorMessage = (String)errorMessage + "Make sure this test is run after 'mvn package'. ";
                if (context.getTestClass().isPresent() && (testClassName = ((Class)context.getTestClass().get()).getName()).endsWith("Test")) {
                    errorMessage = (String)errorMessage + "The easiest way to ensure this is by having the 'maven-failsafe-plugin' run the test instead of the 'maven-surefire-plugin'.";
                }
            } else {
                errorMessage = testLauncher == TestLauncher.GRADLE ? (String)errorMessage + "Make sure this test is run after the 'quarkusBuild' Gradle task." : (String)errorMessage + "Make sure this test is run after the Quarkus artifact is built from your build tool.";
            }
            throw new IllegalStateException((String)errorMessage);
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(artifactProperties.toFile()));
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read artifact metadata file created that must be created by Quarkus in order to run integration tests.", e);
        }
    }

    private static TestLauncher determineTestLauncher() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = stackTrace.length - 1;
        TestLauncher testLauncher = TestLauncher.UNKNOWN;
        do {
            StackTraceElement element;
            String className;
            if ((className = (element = stackTrace[i--]).getClassName()).startsWith("org.apache.maven")) {
                testLauncher = TestLauncher.MAVEN;
                break;
            }
            if (!className.startsWith("org.gradle")) continue;
            testLauncher = TestLauncher.GRADLE;
        } while (i != 0);
        return testLauncher;
    }

    static Path determineBuildOutputDirectory(ExtensionContext context) {
        String buildOutputDirStr = System.getProperty("build.output.directory");
        Path result = null;
        if (buildOutputDirStr != null) {
            result = Paths.get(buildOutputDirStr, new String[0]);
        } else {
            Class testClass = context.getRequiredTestClass();
            CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL codeSourceLocation = codeSource.getLocation();
                File artifactPropertiesDirectory = IntegrationTestUtil.determineBuildOutputDirectory(codeSourceLocation);
                if (artifactPropertiesDirectory == null) {
                    throw new IllegalStateException("Unable to determine the output of the Quarkus build. Consider setting the 'build.output.directory' system property.");
                }
                result = artifactPropertiesDirectory.toPath();
            }
        }
        if (result == null) {
            throw new IllegalStateException("Unable to locate the artifact metadata file created that must be created by Quarkus in order to run tests annotated with '@QuarkusIntegrationTest'.");
        }
        if (!Files.isDirectory(result, new LinkOption[0])) {
            throw new IllegalStateException("The determined Quarkus build output '" + result.toAbsolutePath().toString() + "' is not a directory");
        }
        return result;
    }

    private static File determineBuildOutputDirectory(URL url) {
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file") && url.getPath().endsWith("test-classes/")) {
            return IntegrationTestUtil.toPath(url).getParent().toFile();
        }
        if (url.getProtocol().equals("file") && url.getPath().endsWith("test/")) {
            return IntegrationTestUtil.toPath(url).getParent().getParent().getParent().toFile();
        }
        if (url.getProtocol().equals("file") && url.getPath().contains("/target/surefire/")) {
            String path = url.getPath();
            int index = path.lastIndexOf("/target/");
            try {
                return Paths.get(new URI("file:" + path.substring(0, index) + "/target/")).toFile();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static Path toPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum TestLauncher {
        MAVEN,
        GRADLE,
        UNKNOWN;

    }
}

