/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.MockSupport;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;

public class QuarkusMock {
    public static <T> void installMockForInstance(T mock, T instance) {
        MockSupport.installMock(instance, mock, new Options());
    }

    public static <T> void installMockForInstance(T mock, T instance, Options options) {
        MockSupport.installMock(instance, mock, options);
    }

    public static <T> void installMockForType(T mock, Class<? super T> instance, Annotation ... qualifiers) {
        if (!instance.isAssignableFrom(mock.getClass()) && !instance.getClass().getSuperclass().isAssignableFrom(mock.getClass())) {
            throw new RuntimeException(String.valueOf(mock) + " is not assignable to type " + String.valueOf(instance.getClass().getSuperclass()));
        }
        MockSupport.installMock(CDI.current().select(instance, qualifiers).get(), mock, new Options());
    }

    public static <T> void installMockForType(T mock, TypeLiteral<? super T> typeLiteral, Annotation ... qualifiers) {
        MockSupport.installMock(CDI.current().select(typeLiteral, qualifiers).get(), mock, new Options());
    }

    public static <T> void installMockForType(T mock, TypeLiteral<? super T> typeLiteral, Options options, Annotation ... qualifiers) {
        MockSupport.installMock(CDI.current().select(typeLiteral, qualifiers).get(), mock, options);
    }

    public static class Options {
        private boolean mockObservers;

        public boolean isMockObservers() {
            return this.mockObservers;
        }

        public Options setMockObservers(boolean mockObservers) {
            this.mockObservers = mockObservers;
            return this;
        }
    }
}

