/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.AddExtensionsCommandHandler;
import io.quarkus.cli.commands.Printer;
import io.quarkus.cli.commands.QuarkusCommand;
import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.RemoveExtensions;
import io.quarkus.cli.commands.SelectionResult;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.dependencies.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class RemoveExtensionsCommandHandler
implements QuarkusCommand {
    static final Printer PRINTER = new Printer();

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set extensions = invocation.getValue(RemoveExtensions.EXTENSIONS, Collections.emptySet());
        if (extensions.isEmpty()) {
            return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue(RemoveExtensions.OUTCOME_UPDATED, false);
        }
        boolean updated = false;
        boolean success = true;
        List registry = invocation.getPlatformDescriptor().getExtensions();
        BuildFile buildFile = invocation.getBuildFile();
        try {
            for (String query : extensions) {
                if (query.contains(":")) {
                    updated = buildFile.removeExtensionAsGAV(query) || updated;
                    continue;
                }
                SelectionResult result = AddExtensionsCommandHandler.select(query, registry, false);
                if (!result.matches()) {
                    StringBuilder sb = new StringBuilder();
                    Set<Extension> candidates = result.getExtensions();
                    if (candidates.isEmpty()) {
                        PRINTER.nok(" Cannot find a dependency matching '" + query + "', maybe a typo?");
                        success = false;
                        continue;
                    }
                    sb.append("\u274c").append(" Multiple extensions matching '").append(query).append("'");
                    result.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
                    sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name");
                    PRINTER.print(sb.toString());
                    success = false;
                    continue;
                }
                for (Extension extension2 : result) {
                    updated = buildFile.removeDependency(invocation.getPlatformDescriptor(), extension2) || updated;
                }
            }
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to add extensions", e);
        }
        if (updated) {
            try {
                buildFile.close();
            }
            catch (IOException e) {
                throw new QuarkusCommandException("Failed to update the project", e);
            }
        }
        return (QuarkusCommandOutcome)new QuarkusCommandOutcome(success).setValue(RemoveExtensions.OUTCOME_UPDATED, updated);
    }
}

