/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.CreateProjectCommandHandler;
import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.generators.BuildTool;
import io.quarkus.generators.SourceType;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.config.QuarkusPlatformConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;

public class CreateProject {
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(?:1\\.)?(\\d+)(?:\\..*)?");
    private QuarkusCommandInvocation invocation;
    private String javaTarget;

    public static SourceType determineSourceType(Set<String> extensions) {
        Optional<SourceType> sourceType = extensions.stream().map(SourceType::parse).filter(Optional::isPresent).map(e -> e.orElse(SourceType.JAVA)).findAny();
        return sourceType.orElse(SourceType.JAVA);
    }

    private static boolean isSpringStyle(Collection<String> extensions) {
        return extensions != null && extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"));
    }

    @Deprecated
    public CreateProject(ProjectWriter writer) {
        this(writer, QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor());
    }

    public CreateProject(ProjectWriter writer, QuarkusPlatformDescriptor platformDescr) {
        this.invocation = new QuarkusCommandInvocation(platformDescr);
        this.invocation.setProjectWriter(writer);
    }

    public CreateProject groupId(String groupId) {
        this.setProperty("project_groupId", groupId);
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.setProperty("project_artifactId", artifactId);
        return this;
    }

    public CreateProject version(String version) {
        this.setProperty("project_version", version);
        return this;
    }

    public CreateProject sourceType(SourceType sourceType) {
        this.invocation.setValue("source_type", (Object)sourceType);
        return this;
    }

    public CreateProject javaTarget(String javaTarget) {
        this.javaTarget = javaTarget;
        return this;
    }

    public CreateProject className(String className) {
        if (className == null) {
            return this;
        }
        if (!SourceVersion.isName(className) || SourceVersion.isKeyword(className)) {
            throw new IllegalArgumentException(className + " is not a valid class name");
        }
        this.setProperty("class_name", className);
        return this;
    }

    @Deprecated
    public CreateProject extensions(Set<String> extensions) {
        if (CreateProject.isSpringStyle(extensions)) {
            this.invocation.setValue("is_spring", true);
        }
        return this;
    }

    public CreateProject setProperty(String name, String value) {
        this.invocation.setProperty(name, value);
        return this;
    }

    public CreateProject setValue(String name, Object value) {
        this.invocation.setValue(name, value);
        return this;
    }

    public CreateProject buildFile(BuildFile buildFile) {
        this.invocation.setBuildFile(buildFile);
        return this;
    }

    public CreateProject buildTool(BuildTool buildTool) {
        this.invocation.setBuildTool(buildTool);
        return this;
    }

    public boolean doCreateProject(Map<String, Object> context) throws IOException {
        if (context != null && !context.isEmpty()) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (entry.getValue() == null) continue;
                this.invocation.setProperty(entry.getKey(), entry.getValue().toString());
            }
        }
        try {
            return this.execute().isSuccess();
        }
        catch (QuarkusCommandException e) {
            throw new IOException("Failed to create project", e);
        }
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        Matcher matcher = JAVA_VERSION_PATTERN.matcher(this.javaTarget != null ? this.javaTarget : System.getProperty("java.version", ""));
        if (matcher.matches() && Integer.parseInt(matcher.group(1)) < 11) {
            this.invocation.setProperty("java_target", "8");
        } else {
            this.invocation.setProperty("java_target", "11");
        }
        return new CreateProjectCommandHandler().execute(this.invocation);
    }
}

