/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dependencies;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;

public class Extension {
    private String artifactId;
    private String groupId;
    private String scope;
    private String version;
    private String type;
    private String classifier;
    private String name;
    private String description;
    private boolean internal = false;
    private String[] labels;
    private String guide;
    private String simplifiedArtifactId;
    private static final Pattern QUARKUS_PREFIX = Pattern.compile("^quarkus-");
    private String shortName;

    public Extension() {
    }

    public Extension(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.setArtifactId(artifactId);
        this.version = version;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Extension setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        this.simplifiedArtifactId = QUARKUS_PREFIX.matcher(artifactId).replaceFirst("");
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Extension setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public Extension setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Extension setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Extension setType(String type) {
        this.type = type;
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Extension setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public Extension setLabels(String[] labels) {
        this.labels = labels;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Extension setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Extension setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public Extension setInternal(boolean internal) {
        this.internal = internal;
        return this;
    }

    public List<String> labels() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.labels != null) {
            list.addAll(Stream.of(this.labels).map(String::toLowerCase).collect(Collectors.toList()));
        }
        list.add(this.artifactId.toLowerCase());
        return list;
    }

    public Dependency toDependency(boolean stripVersion) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.groupId);
        dependency.setArtifactId(this.artifactId);
        if (this.scope != null && !this.scope.isEmpty()) {
            dependency.setScope(this.scope);
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            dependency.setClassifier(this.classifier);
        }
        if (this.version != null && !this.version.isEmpty() && !stripVersion) {
            dependency.setVersion(this.version);
        }
        return dependency;
    }

    public String managementKey() {
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public String gav() {
        return this.managementKey() + ":" + this.version;
    }

    public String getSimplifiedArtifactId() {
        return this.simplifiedArtifactId;
    }

    public String toString() {
        return this.gav();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Extension other = (Extension)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getGuide() {
        return this.guide;
    }

    public String getShortName() {
        if (this.shortName == null) {
            return this.name;
        }
        return this.shortName;
    }

    public Extension setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }
}

